/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.ApiEntityReference;
import com.azure.resourcemanager.computefleet.models.IPVersion;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetPublicIPAddressConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetIPConfigurationProperties
implements JsonSerializable<VirtualMachineScaleSetIPConfigurationProperties> {
    private ApiEntityReference subnet;
    private Boolean primary;
    private VirtualMachineScaleSetPublicIPAddressConfiguration publicIPAddressConfiguration;
    private IPVersion privateIPAddressVersion;
    private List<SubResource> applicationGatewayBackendAddressPools;
    private List<SubResource> applicationSecurityGroups;
    private List<SubResource> loadBalancerBackendAddressPools;
    private List<SubResource> loadBalancerInboundNatPools;

    public ApiEntityReference subnet() {
        return this.subnet;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withSubnet(ApiEntityReference subnet) {
        this.subnet = subnet;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public VirtualMachineScaleSetPublicIPAddressConfiguration publicIPAddressConfiguration() {
        return this.publicIPAddressConfiguration;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withPublicIPAddressConfiguration(VirtualMachineScaleSetPublicIPAddressConfiguration publicIPAddressConfiguration) {
        this.publicIPAddressConfiguration = publicIPAddressConfiguration;
        return this;
    }

    public IPVersion privateIPAddressVersion() {
        return this.privateIPAddressVersion;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withPrivateIPAddressVersion(IPVersion privateIPAddressVersion) {
        this.privateIPAddressVersion = privateIPAddressVersion;
        return this;
    }

    public List<SubResource> applicationGatewayBackendAddressPools() {
        return this.applicationGatewayBackendAddressPools;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withApplicationGatewayBackendAddressPools(List<SubResource> applicationGatewayBackendAddressPools) {
        this.applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools;
        return this;
    }

    public List<SubResource> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withApplicationSecurityGroups(List<SubResource> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public List<SubResource> loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withLoadBalancerBackendAddressPools(List<SubResource> loadBalancerBackendAddressPools) {
        this.loadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
        return this;
    }

    public List<SubResource> loadBalancerInboundNatPools() {
        return this.loadBalancerInboundNatPools;
    }

    public VirtualMachineScaleSetIPConfigurationProperties withLoadBalancerInboundNatPools(List<SubResource> loadBalancerInboundNatPools) {
        this.loadBalancerInboundNatPools = loadBalancerInboundNatPools;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeJsonField("publicIPAddressConfiguration", (JsonSerializable)this.publicIPAddressConfiguration);
        jsonWriter.writeStringField("privateIPAddressVersion", this.privateIPAddressVersion == null ? null : this.privateIPAddressVersion.toString());
        jsonWriter.writeArrayField("applicationGatewayBackendAddressPools", this.applicationGatewayBackendAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationSecurityGroups", this.applicationSecurityGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("loadBalancerBackendAddressPools", this.loadBalancerBackendAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("loadBalancerInboundNatPools", this.loadBalancerInboundNatPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetIPConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetIPConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetIPConfigurationProperties deserializedVirtualMachineScaleSetIPConfigurationProperties = new VirtualMachineScaleSetIPConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.subnet = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicIPAddressConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.publicIPAddressConfiguration = VirtualMachineScaleSetPublicIPAddressConfiguration.fromJson(reader);
                    continue;
                }
                if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.privateIPAddressVersion = IPVersion.fromString(reader.getString());
                    continue;
                }
                if ("applicationGatewayBackendAddressPools".equals(fieldName)) {
                    List applicationGatewayBackendAddressPools;
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("applicationSecurityGroups".equals(fieldName)) {
                    List applicationSecurityGroups;
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.applicationSecurityGroups = applicationSecurityGroups = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("loadBalancerBackendAddressPools".equals(fieldName)) {
                    List loadBalancerBackendAddressPools;
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.loadBalancerBackendAddressPools = loadBalancerBackendAddressPools = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("loadBalancerInboundNatPools".equals(fieldName)) {
                    List loadBalancerInboundNatPools;
                    deserializedVirtualMachineScaleSetIPConfigurationProperties.loadBalancerInboundNatPools = loadBalancerInboundNatPools = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetIPConfigurationProperties;
        });
    }
}

