/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.KeyVaultSecretReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineScaleSetExtensionProperties
implements JsonSerializable<VirtualMachineScaleSetExtensionProperties> {
    private String forceUpdateTag;
    private String publisher;
    private String type;
    private String typeHandlerVersion;
    private Boolean autoUpgradeMinorVersion;
    private Boolean enableAutomaticUpgrade;
    private Map<String, BinaryData> settings;
    private Map<String, BinaryData> protectedSettings;
    private String provisioningState;
    private List<String> provisionAfterExtensions;
    private Boolean suppressFailures;
    private KeyVaultSecretReference protectedSettingsFromKeyVault;

    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    public VirtualMachineScaleSetExtensionProperties withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    public String publisher() {
        return this.publisher;
    }

    public VirtualMachineScaleSetExtensionProperties withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String type() {
        return this.type;
    }

    public VirtualMachineScaleSetExtensionProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public VirtualMachineScaleSetExtensionProperties withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public Boolean autoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    public VirtualMachineScaleSetExtensionProperties withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    public VirtualMachineScaleSetExtensionProperties withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    public Map<String, BinaryData> settings() {
        return this.settings;
    }

    public VirtualMachineScaleSetExtensionProperties withSettings(Map<String, BinaryData> settings) {
        this.settings = settings;
        return this;
    }

    public Map<String, BinaryData> protectedSettings() {
        return this.protectedSettings;
    }

    public VirtualMachineScaleSetExtensionProperties withProtectedSettings(Map<String, BinaryData> protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<String> provisionAfterExtensions() {
        return this.provisionAfterExtensions;
    }

    public VirtualMachineScaleSetExtensionProperties withProvisionAfterExtensions(List<String> provisionAfterExtensions) {
        this.provisionAfterExtensions = provisionAfterExtensions;
        return this;
    }

    public Boolean suppressFailures() {
        return this.suppressFailures;
    }

    public VirtualMachineScaleSetExtensionProperties withSuppressFailures(Boolean suppressFailures) {
        this.suppressFailures = suppressFailures;
        return this;
    }

    public KeyVaultSecretReference protectedSettingsFromKeyVault() {
        return this.protectedSettingsFromKeyVault;
    }

    public VirtualMachineScaleSetExtensionProperties withProtectedSettingsFromKeyVault(KeyVaultSecretReference protectedSettingsFromKeyVault) {
        this.protectedSettingsFromKeyVault = protectedSettingsFromKeyVault;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("forceUpdateTag", this.forceUpdateTag);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeMapField("protectedSettings", this.protectedSettings, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeArrayField("provisionAfterExtensions", this.provisionAfterExtensions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("suppressFailures", this.suppressFailures);
        jsonWriter.writeJsonField("protectedSettingsFromKeyVault", (JsonSerializable)this.protectedSettingsFromKeyVault);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetExtensionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetExtensionProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetExtensionProperties deserializedVirtualMachineScaleSetExtensionProperties = new VirtualMachineScaleSetExtensionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("forceUpdateTag".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.forceUpdateTag = reader.getString();
                    continue;
                }
                if ("publisher".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.publisher = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.autoUpgradeMinorVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.enableAutomaticUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    Map settings;
                    deserializedVirtualMachineScaleSetExtensionProperties.settings = settings = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    Map protectedSettings;
                    deserializedVirtualMachineScaleSetExtensionProperties.protectedSettings = protectedSettings = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("provisionAfterExtensions".equals(fieldName)) {
                    List provisionAfterExtensions;
                    deserializedVirtualMachineScaleSetExtensionProperties.provisionAfterExtensions = provisionAfterExtensions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("suppressFailures".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.suppressFailures = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("protectedSettingsFromKeyVault".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionProperties.protectedSettingsFromKeyVault = KeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetExtensionProperties;
        });
    }
}

