/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.CachingTypes;
import com.azure.resourcemanager.computefleet.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.computefleet.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetManagedDiskParameters;
import java.io.IOException;

public final class VirtualMachineScaleSetDataDisk
implements JsonSerializable<VirtualMachineScaleSetDataDisk> {
    private String name;
    private int lun;
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiskCreateOptionTypes createOption;
    private Integer diskSizeGB;
    private VirtualMachineScaleSetManagedDiskParameters managedDisk;
    private Long diskIOPSReadWrite;
    private Long diskMBpsReadWrite;
    private DiskDeleteOptionTypes deleteOption;

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetDataDisk withName(String name) {
        this.name = name;
        return this;
    }

    public int lun() {
        return this.lun;
    }

    public VirtualMachineScaleSetDataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public VirtualMachineScaleSetDataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public VirtualMachineScaleSetDataDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public VirtualMachineScaleSetDataDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualMachineScaleSetDataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public VirtualMachineScaleSetManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public VirtualMachineScaleSetDataDisk withManagedDisk(VirtualMachineScaleSetManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public Long diskIOPSReadWrite() {
        return this.diskIOPSReadWrite;
    }

    public VirtualMachineScaleSetDataDisk withDiskIOPSReadWrite(Long diskIOPSReadWrite) {
        this.diskIOPSReadWrite = diskIOPSReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public VirtualMachineScaleSetDataDisk withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetDataDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeNumberField("diskIOPSReadWrite", (Number)this.diskIOPSReadWrite);
        jsonWriter.writeNumberField("diskMBpsReadWrite", (Number)this.diskMBpsReadWrite);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetDataDisk fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetDataDisk)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetDataDisk deserializedVirtualMachineScaleSetDataDisk = new VirtualMachineScaleSetDataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.lun = reader.getInt();
                    continue;
                }
                if ("createOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.name = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.managedDisk = VirtualMachineScaleSetManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskIOPSReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.diskMBpsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetDataDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetDataDisk;
        });
    }
}

