/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.computefleet.models.SecurityEncryptionTypes;
import java.io.IOException;

public final class VMDiskSecurityProfile
implements JsonSerializable<VMDiskSecurityProfile> {
    private SecurityEncryptionTypes securityEncryptionType;
    private DiskEncryptionSetParameters diskEncryptionSet;

    public SecurityEncryptionTypes securityEncryptionType() {
        return this.securityEncryptionType;
    }

    public VMDiskSecurityProfile withSecurityEncryptionType(SecurityEncryptionTypes securityEncryptionType) {
        this.securityEncryptionType = securityEncryptionType;
        return this;
    }

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public VMDiskSecurityProfile withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityEncryptionType", this.securityEncryptionType == null ? null : this.securityEncryptionType.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        return jsonWriter.writeEndObject();
    }

    public static VMDiskSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VMDiskSecurityProfile)jsonReader.readObject(reader -> {
            VMDiskSecurityProfile deserializedVMDiskSecurityProfile = new VMDiskSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("securityEncryptionType".equals(fieldName)) {
                    deserializedVMDiskSecurityProfile.securityEncryptionType = SecurityEncryptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedVMDiskSecurityProfile.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMDiskSecurityProfile;
        });
    }
}

