/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.AcceleratorManufacturer;
import com.azure.resourcemanager.computefleet.models.AcceleratorType;
import com.azure.resourcemanager.computefleet.models.ArchitectureType;
import com.azure.resourcemanager.computefleet.models.CpuManufacturer;
import com.azure.resourcemanager.computefleet.models.LocalStorageDiskType;
import com.azure.resourcemanager.computefleet.models.VMAttributeMinMaxDouble;
import com.azure.resourcemanager.computefleet.models.VMAttributeMinMaxInteger;
import com.azure.resourcemanager.computefleet.models.VMAttributeSupport;
import com.azure.resourcemanager.computefleet.models.VMCategory;
import java.io.IOException;
import java.util.List;

public final class VMAttributes
implements JsonSerializable<VMAttributes> {
    private VMAttributeMinMaxInteger vCpuCount;
    private VMAttributeMinMaxDouble memoryInGiB;
    private VMAttributeMinMaxDouble memoryInGiBPerVCpu;
    private VMAttributeSupport localStorageSupport;
    private VMAttributeMinMaxDouble localStorageInGiB;
    private List<LocalStorageDiskType> localStorageDiskTypes;
    private VMAttributeMinMaxInteger dataDiskCount;
    private VMAttributeMinMaxInteger networkInterfaceCount;
    private VMAttributeMinMaxDouble networkBandwidthInMbps;
    private VMAttributeSupport rdmaSupport;
    private VMAttributeMinMaxInteger rdmaNetworkInterfaceCount;
    private VMAttributeSupport acceleratorSupport;
    private List<AcceleratorManufacturer> acceleratorManufacturers;
    private List<AcceleratorType> acceleratorTypes;
    private VMAttributeMinMaxInteger acceleratorCount;
    private List<VMCategory> vmCategories;
    private List<ArchitectureType> architectureTypes;
    private List<CpuManufacturer> cpuManufacturers;
    private VMAttributeSupport burstableSupport;
    private List<String> excludedVMSizes;

    public VMAttributeMinMaxInteger vCpuCount() {
        return this.vCpuCount;
    }

    public VMAttributes withVCpuCount(VMAttributeMinMaxInteger vCpuCount) {
        this.vCpuCount = vCpuCount;
        return this;
    }

    public VMAttributeMinMaxDouble memoryInGiB() {
        return this.memoryInGiB;
    }

    public VMAttributes withMemoryInGiB(VMAttributeMinMaxDouble memoryInGiB) {
        this.memoryInGiB = memoryInGiB;
        return this;
    }

    public VMAttributeMinMaxDouble memoryInGiBPerVCpu() {
        return this.memoryInGiBPerVCpu;
    }

    public VMAttributes withMemoryInGiBPerVCpu(VMAttributeMinMaxDouble memoryInGiBPerVCpu) {
        this.memoryInGiBPerVCpu = memoryInGiBPerVCpu;
        return this;
    }

    public VMAttributeSupport localStorageSupport() {
        return this.localStorageSupport;
    }

    public VMAttributes withLocalStorageSupport(VMAttributeSupport localStorageSupport) {
        this.localStorageSupport = localStorageSupport;
        return this;
    }

    public VMAttributeMinMaxDouble localStorageInGiB() {
        return this.localStorageInGiB;
    }

    public VMAttributes withLocalStorageInGiB(VMAttributeMinMaxDouble localStorageInGiB) {
        this.localStorageInGiB = localStorageInGiB;
        return this;
    }

    public List<LocalStorageDiskType> localStorageDiskTypes() {
        return this.localStorageDiskTypes;
    }

    public VMAttributes withLocalStorageDiskTypes(List<LocalStorageDiskType> localStorageDiskTypes) {
        this.localStorageDiskTypes = localStorageDiskTypes;
        return this;
    }

    public VMAttributeMinMaxInteger dataDiskCount() {
        return this.dataDiskCount;
    }

    public VMAttributes withDataDiskCount(VMAttributeMinMaxInteger dataDiskCount) {
        this.dataDiskCount = dataDiskCount;
        return this;
    }

    public VMAttributeMinMaxInteger networkInterfaceCount() {
        return this.networkInterfaceCount;
    }

    public VMAttributes withNetworkInterfaceCount(VMAttributeMinMaxInteger networkInterfaceCount) {
        this.networkInterfaceCount = networkInterfaceCount;
        return this;
    }

    public VMAttributeMinMaxDouble networkBandwidthInMbps() {
        return this.networkBandwidthInMbps;
    }

    public VMAttributes withNetworkBandwidthInMbps(VMAttributeMinMaxDouble networkBandwidthInMbps) {
        this.networkBandwidthInMbps = networkBandwidthInMbps;
        return this;
    }

    public VMAttributeSupport rdmaSupport() {
        return this.rdmaSupport;
    }

    public VMAttributes withRdmaSupport(VMAttributeSupport rdmaSupport) {
        this.rdmaSupport = rdmaSupport;
        return this;
    }

    public VMAttributeMinMaxInteger rdmaNetworkInterfaceCount() {
        return this.rdmaNetworkInterfaceCount;
    }

    public VMAttributes withRdmaNetworkInterfaceCount(VMAttributeMinMaxInteger rdmaNetworkInterfaceCount) {
        this.rdmaNetworkInterfaceCount = rdmaNetworkInterfaceCount;
        return this;
    }

    public VMAttributeSupport acceleratorSupport() {
        return this.acceleratorSupport;
    }

    public VMAttributes withAcceleratorSupport(VMAttributeSupport acceleratorSupport) {
        this.acceleratorSupport = acceleratorSupport;
        return this;
    }

    public List<AcceleratorManufacturer> acceleratorManufacturers() {
        return this.acceleratorManufacturers;
    }

    public VMAttributes withAcceleratorManufacturers(List<AcceleratorManufacturer> acceleratorManufacturers) {
        this.acceleratorManufacturers = acceleratorManufacturers;
        return this;
    }

    public List<AcceleratorType> acceleratorTypes() {
        return this.acceleratorTypes;
    }

    public VMAttributes withAcceleratorTypes(List<AcceleratorType> acceleratorTypes) {
        this.acceleratorTypes = acceleratorTypes;
        return this;
    }

    public VMAttributeMinMaxInteger acceleratorCount() {
        return this.acceleratorCount;
    }

    public VMAttributes withAcceleratorCount(VMAttributeMinMaxInteger acceleratorCount) {
        this.acceleratorCount = acceleratorCount;
        return this;
    }

    public List<VMCategory> vmCategories() {
        return this.vmCategories;
    }

    public VMAttributes withVmCategories(List<VMCategory> vmCategories) {
        this.vmCategories = vmCategories;
        return this;
    }

    public List<ArchitectureType> architectureTypes() {
        return this.architectureTypes;
    }

    public VMAttributes withArchitectureTypes(List<ArchitectureType> architectureTypes) {
        this.architectureTypes = architectureTypes;
        return this;
    }

    public List<CpuManufacturer> cpuManufacturers() {
        return this.cpuManufacturers;
    }

    public VMAttributes withCpuManufacturers(List<CpuManufacturer> cpuManufacturers) {
        this.cpuManufacturers = cpuManufacturers;
        return this;
    }

    public VMAttributeSupport burstableSupport() {
        return this.burstableSupport;
    }

    public VMAttributes withBurstableSupport(VMAttributeSupport burstableSupport) {
        this.burstableSupport = burstableSupport;
        return this;
    }

    public List<String> excludedVMSizes() {
        return this.excludedVMSizes;
    }

    public VMAttributes withExcludedVMSizes(List<String> excludedVMSizes) {
        this.excludedVMSizes = excludedVMSizes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vCpuCount", (JsonSerializable)this.vCpuCount);
        jsonWriter.writeJsonField("memoryInGiB", (JsonSerializable)this.memoryInGiB);
        jsonWriter.writeJsonField("memoryInGiBPerVCpu", (JsonSerializable)this.memoryInGiBPerVCpu);
        jsonWriter.writeStringField("localStorageSupport", this.localStorageSupport == null ? null : this.localStorageSupport.toString());
        jsonWriter.writeJsonField("localStorageInGiB", (JsonSerializable)this.localStorageInGiB);
        jsonWriter.writeArrayField("localStorageDiskTypes", this.localStorageDiskTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("dataDiskCount", (JsonSerializable)this.dataDiskCount);
        jsonWriter.writeJsonField("networkInterfaceCount", (JsonSerializable)this.networkInterfaceCount);
        jsonWriter.writeJsonField("networkBandwidthInMbps", (JsonSerializable)this.networkBandwidthInMbps);
        jsonWriter.writeStringField("rdmaSupport", this.rdmaSupport == null ? null : this.rdmaSupport.toString());
        jsonWriter.writeJsonField("rdmaNetworkInterfaceCount", (JsonSerializable)this.rdmaNetworkInterfaceCount);
        jsonWriter.writeStringField("acceleratorSupport", this.acceleratorSupport == null ? null : this.acceleratorSupport.toString());
        jsonWriter.writeArrayField("acceleratorManufacturers", this.acceleratorManufacturers, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("acceleratorTypes", this.acceleratorTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("acceleratorCount", (JsonSerializable)this.acceleratorCount);
        jsonWriter.writeArrayField("vmCategories", this.vmCategories, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("architectureTypes", this.architectureTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("cpuManufacturers", this.cpuManufacturers, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("burstableSupport", this.burstableSupport == null ? null : this.burstableSupport.toString());
        jsonWriter.writeArrayField("excludedVMSizes", this.excludedVMSizes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VMAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (VMAttributes)jsonReader.readObject(reader -> {
            VMAttributes deserializedVMAttributes = new VMAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vCpuCount".equals(fieldName)) {
                    deserializedVMAttributes.vCpuCount = VMAttributeMinMaxInteger.fromJson(reader);
                    continue;
                }
                if ("memoryInGiB".equals(fieldName)) {
                    deserializedVMAttributes.memoryInGiB = VMAttributeMinMaxDouble.fromJson(reader);
                    continue;
                }
                if ("memoryInGiBPerVCpu".equals(fieldName)) {
                    deserializedVMAttributes.memoryInGiBPerVCpu = VMAttributeMinMaxDouble.fromJson(reader);
                    continue;
                }
                if ("localStorageSupport".equals(fieldName)) {
                    deserializedVMAttributes.localStorageSupport = VMAttributeSupport.fromString(reader.getString());
                    continue;
                }
                if ("localStorageInGiB".equals(fieldName)) {
                    deserializedVMAttributes.localStorageInGiB = VMAttributeMinMaxDouble.fromJson(reader);
                    continue;
                }
                if ("localStorageDiskTypes".equals(fieldName)) {
                    List localStorageDiskTypes;
                    deserializedVMAttributes.localStorageDiskTypes = localStorageDiskTypes = reader.readArray(reader1 -> LocalStorageDiskType.fromString(reader1.getString()));
                    continue;
                }
                if ("dataDiskCount".equals(fieldName)) {
                    deserializedVMAttributes.dataDiskCount = VMAttributeMinMaxInteger.fromJson(reader);
                    continue;
                }
                if ("networkInterfaceCount".equals(fieldName)) {
                    deserializedVMAttributes.networkInterfaceCount = VMAttributeMinMaxInteger.fromJson(reader);
                    continue;
                }
                if ("networkBandwidthInMbps".equals(fieldName)) {
                    deserializedVMAttributes.networkBandwidthInMbps = VMAttributeMinMaxDouble.fromJson(reader);
                    continue;
                }
                if ("rdmaSupport".equals(fieldName)) {
                    deserializedVMAttributes.rdmaSupport = VMAttributeSupport.fromString(reader.getString());
                    continue;
                }
                if ("rdmaNetworkInterfaceCount".equals(fieldName)) {
                    deserializedVMAttributes.rdmaNetworkInterfaceCount = VMAttributeMinMaxInteger.fromJson(reader);
                    continue;
                }
                if ("acceleratorSupport".equals(fieldName)) {
                    deserializedVMAttributes.acceleratorSupport = VMAttributeSupport.fromString(reader.getString());
                    continue;
                }
                if ("acceleratorManufacturers".equals(fieldName)) {
                    List acceleratorManufacturers;
                    deserializedVMAttributes.acceleratorManufacturers = acceleratorManufacturers = reader.readArray(reader1 -> AcceleratorManufacturer.fromString(reader1.getString()));
                    continue;
                }
                if ("acceleratorTypes".equals(fieldName)) {
                    List acceleratorTypes;
                    deserializedVMAttributes.acceleratorTypes = acceleratorTypes = reader.readArray(reader1 -> AcceleratorType.fromString(reader1.getString()));
                    continue;
                }
                if ("acceleratorCount".equals(fieldName)) {
                    deserializedVMAttributes.acceleratorCount = VMAttributeMinMaxInteger.fromJson(reader);
                    continue;
                }
                if ("vmCategories".equals(fieldName)) {
                    List vmCategories;
                    deserializedVMAttributes.vmCategories = vmCategories = reader.readArray(reader1 -> VMCategory.fromString(reader1.getString()));
                    continue;
                }
                if ("architectureTypes".equals(fieldName)) {
                    List architectureTypes;
                    deserializedVMAttributes.architectureTypes = architectureTypes = reader.readArray(reader1 -> ArchitectureType.fromString(reader1.getString()));
                    continue;
                }
                if ("cpuManufacturers".equals(fieldName)) {
                    List cpuManufacturers;
                    deserializedVMAttributes.cpuManufacturers = cpuManufacturers = reader.readArray(reader1 -> CpuManufacturer.fromString(reader1.getString()));
                    continue;
                }
                if ("burstableSupport".equals(fieldName)) {
                    deserializedVMAttributes.burstableSupport = VMAttributeSupport.fromString(reader.getString());
                    continue;
                }
                if ("excludedVMSizes".equals(fieldName)) {
                    List excludedVMSizes;
                    deserializedVMAttributes.excludedVMSizes = excludedVMSizes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMAttributes;
        });
    }
}

