/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.EncryptionIdentity;
import com.azure.resourcemanager.computefleet.models.ProxyAgentSettings;
import com.azure.resourcemanager.computefleet.models.SecurityTypes;
import com.azure.resourcemanager.computefleet.models.UefiSettings;
import java.io.IOException;

public final class SecurityProfile
implements JsonSerializable<SecurityProfile> {
    private UefiSettings uefiSettings;
    private Boolean encryptionAtHost;
    private SecurityTypes securityType;
    private EncryptionIdentity encryptionIdentity;
    private ProxyAgentSettings proxyAgentSettings;

    public UefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    public SecurityProfile withUefiSettings(UefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    public Boolean encryptionAtHost() {
        return this.encryptionAtHost;
    }

    public SecurityProfile withEncryptionAtHost(Boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
        return this;
    }

    public SecurityTypes securityType() {
        return this.securityType;
    }

    public SecurityProfile withSecurityType(SecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    public EncryptionIdentity encryptionIdentity() {
        return this.encryptionIdentity;
    }

    public SecurityProfile withEncryptionIdentity(EncryptionIdentity encryptionIdentity) {
        this.encryptionIdentity = encryptionIdentity;
        return this;
    }

    public ProxyAgentSettings proxyAgentSettings() {
        return this.proxyAgentSettings;
    }

    public SecurityProfile withProxyAgentSettings(ProxyAgentSettings proxyAgentSettings) {
        this.proxyAgentSettings = proxyAgentSettings;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("uefiSettings", (JsonSerializable)this.uefiSettings);
        jsonWriter.writeBooleanField("encryptionAtHost", this.encryptionAtHost);
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        jsonWriter.writeJsonField("encryptionIdentity", (JsonSerializable)this.encryptionIdentity);
        jsonWriter.writeJsonField("proxyAgentSettings", (JsonSerializable)this.proxyAgentSettings);
        return jsonWriter.writeEndObject();
    }

    public static SecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityProfile)jsonReader.readObject(reader -> {
            SecurityProfile deserializedSecurityProfile = new SecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uefiSettings".equals(fieldName)) {
                    deserializedSecurityProfile.uefiSettings = UefiSettings.fromJson(reader);
                    continue;
                }
                if ("encryptionAtHost".equals(fieldName)) {
                    deserializedSecurityProfile.encryptionAtHost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityType".equals(fieldName)) {
                    deserializedSecurityProfile.securityType = SecurityTypes.fromString(reader.getString());
                    continue;
                }
                if ("encryptionIdentity".equals(fieldName)) {
                    deserializedSecurityProfile.encryptionIdentity = EncryptionIdentity.fromJson(reader);
                    continue;
                }
                if ("proxyAgentSettings".equals(fieldName)) {
                    deserializedSecurityProfile.proxyAgentSettings = ProxyAgentSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityProfile;
        });
    }
}

