/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.computefleet.fluent.models.FleetInner;
import com.azure.resourcemanager.computefleet.models.FleetProperties;
import com.azure.resourcemanager.computefleet.models.ManagedServiceIdentity;
import com.azure.resourcemanager.computefleet.models.ManagedServiceIdentityUpdate;
import com.azure.resourcemanager.computefleet.models.Plan;
import com.azure.resourcemanager.computefleet.models.ResourcePlanUpdate;
import java.util.List;
import java.util.Map;

public interface Fleet {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public FleetProperties properties();

    public List<String> zones();

    public ManagedServiceIdentity identity();

    public Plan plan();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public FleetInner innerModel();

    public Update update();

    public Fleet refresh();

    public Fleet refresh(Context var1);

    public void cancel();

    public void cancel(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(FleetProperties var1);
        }

        public static interface WithPlan {
            public Update withPlan(ResourcePlanUpdate var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentityUpdate var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithPlan,
    UpdateStages.WithProperties {
        public Fleet apply();

        public Fleet apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPlan {
            public WithCreate withPlan(Plan var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(FleetProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithZones,
        WithIdentity,
        WithPlan {
            public Fleet create();

            public Fleet create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

