/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.ApplicationProfile;
import com.azure.resourcemanager.computefleet.models.CapacityReservationProfile;
import com.azure.resourcemanager.computefleet.models.DiagnosticsProfile;
import com.azure.resourcemanager.computefleet.models.ScheduledEventsProfile;
import com.azure.resourcemanager.computefleet.models.SecurityPostureReference;
import com.azure.resourcemanager.computefleet.models.SecurityProfile;
import com.azure.resourcemanager.computefleet.models.ServiceArtifactReference;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetExtensionProfile;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetHardwareProfile;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetNetworkProfile;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetOSProfile;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BaseVirtualMachineProfile
implements JsonSerializable<BaseVirtualMachineProfile> {
    private VirtualMachineScaleSetOSProfile osProfile;
    private VirtualMachineScaleSetStorageProfile storageProfile;
    private VirtualMachineScaleSetNetworkProfile networkProfile;
    private SecurityProfile securityProfile;
    private DiagnosticsProfile diagnosticsProfile;
    private VirtualMachineScaleSetExtensionProfile extensionProfile;
    private String licenseType;
    private ScheduledEventsProfile scheduledEventsProfile;
    private String userData;
    private CapacityReservationProfile capacityReservation;
    private ApplicationProfile applicationProfile;
    private VirtualMachineScaleSetHardwareProfile hardwareProfile;
    private ServiceArtifactReference serviceArtifactReference;
    private SecurityPostureReference securityPostureReference;
    private OffsetDateTime timeCreated;

    public VirtualMachineScaleSetOSProfile osProfile() {
        return this.osProfile;
    }

    public BaseVirtualMachineProfile withOsProfile(VirtualMachineScaleSetOSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public VirtualMachineScaleSetStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public BaseVirtualMachineProfile withStorageProfile(VirtualMachineScaleSetStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public VirtualMachineScaleSetNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public BaseVirtualMachineProfile withNetworkProfile(VirtualMachineScaleSetNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public BaseVirtualMachineProfile withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public BaseVirtualMachineProfile withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public VirtualMachineScaleSetExtensionProfile extensionProfile() {
        return this.extensionProfile;
    }

    public BaseVirtualMachineProfile withExtensionProfile(VirtualMachineScaleSetExtensionProfile extensionProfile) {
        this.extensionProfile = extensionProfile;
        return this;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public BaseVirtualMachineProfile withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.scheduledEventsProfile;
    }

    public BaseVirtualMachineProfile withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        this.scheduledEventsProfile = scheduledEventsProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public BaseVirtualMachineProfile withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public CapacityReservationProfile capacityReservation() {
        return this.capacityReservation;
    }

    public BaseVirtualMachineProfile withCapacityReservation(CapacityReservationProfile capacityReservation) {
        this.capacityReservation = capacityReservation;
        return this;
    }

    public ApplicationProfile applicationProfile() {
        return this.applicationProfile;
    }

    public BaseVirtualMachineProfile withApplicationProfile(ApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
        return this;
    }

    public VirtualMachineScaleSetHardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public BaseVirtualMachineProfile withHardwareProfile(VirtualMachineScaleSetHardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public ServiceArtifactReference serviceArtifactReference() {
        return this.serviceArtifactReference;
    }

    public BaseVirtualMachineProfile withServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    public SecurityPostureReference securityPostureReference() {
        return this.securityPostureReference;
    }

    public BaseVirtualMachineProfile withSecurityPostureReference(SecurityPostureReference securityPostureReference) {
        this.securityPostureReference = securityPostureReference;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("diagnosticsProfile", (JsonSerializable)this.diagnosticsProfile);
        jsonWriter.writeJsonField("extensionProfile", (JsonSerializable)this.extensionProfile);
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeJsonField("scheduledEventsProfile", (JsonSerializable)this.scheduledEventsProfile);
        jsonWriter.writeStringField("userData", this.userData);
        jsonWriter.writeJsonField("capacityReservation", (JsonSerializable)this.capacityReservation);
        jsonWriter.writeJsonField("applicationProfile", (JsonSerializable)this.applicationProfile);
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeJsonField("serviceArtifactReference", (JsonSerializable)this.serviceArtifactReference);
        jsonWriter.writeJsonField("securityPostureReference", (JsonSerializable)this.securityPostureReference);
        return jsonWriter.writeEndObject();
    }

    public static BaseVirtualMachineProfile fromJson(JsonReader jsonReader) throws IOException {
        return (BaseVirtualMachineProfile)jsonReader.readObject(reader -> {
            BaseVirtualMachineProfile deserializedBaseVirtualMachineProfile = new BaseVirtualMachineProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.osProfile = VirtualMachineScaleSetOSProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.storageProfile = VirtualMachineScaleSetStorageProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.networkProfile = VirtualMachineScaleSetNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("diagnosticsProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.diagnosticsProfile = DiagnosticsProfile.fromJson(reader);
                    continue;
                }
                if ("extensionProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.extensionProfile = VirtualMachineScaleSetExtensionProfile.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.licenseType = reader.getString();
                    continue;
                }
                if ("scheduledEventsProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.scheduledEventsProfile = ScheduledEventsProfile.fromJson(reader);
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.userData = reader.getString();
                    continue;
                }
                if ("capacityReservation".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.capacityReservation = CapacityReservationProfile.fromJson(reader);
                    continue;
                }
                if ("applicationProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.applicationProfile = ApplicationProfile.fromJson(reader);
                    continue;
                }
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.hardwareProfile = VirtualMachineScaleSetHardwareProfile.fromJson(reader);
                    continue;
                }
                if ("serviceArtifactReference".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.serviceArtifactReference = ServiceArtifactReference.fromJson(reader);
                    continue;
                }
                if ("securityPostureReference".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.securityPostureReference = SecurityPostureReference.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedBaseVirtualMachineProfile.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseVirtualMachineProfile;
        });
    }
}

