/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.ApiErrorBase;
import com.azure.resourcemanager.computefleet.models.InnerError;
import java.io.IOException;
import java.util.List;

public final class ApiError
implements JsonSerializable<ApiError> {
    private String code;
    private String target;
    private String message;
    private List<ApiErrorBase> details;
    private InnerError innererror;

    private ApiError() {
    }

    public String code() {
        return this.code;
    }

    public String target() {
        return this.target;
    }

    public String message() {
        return this.message;
    }

    public List<ApiErrorBase> details() {
        return this.details;
    }

    public InnerError innererror() {
        return this.innererror;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        return jsonWriter.writeEndObject();
    }

    public static ApiError fromJson(JsonReader jsonReader) throws IOException {
        return (ApiError)jsonReader.readObject(reader -> {
            ApiError deserializedApiError = new ApiError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedApiError.code = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedApiError.target = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedApiError.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedApiError.details = details = reader.readArray(reader1 -> ApiErrorBase.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    deserializedApiError.innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiError;
        });
    }
}

