/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.computefleet.ComputeFleetManager;
import com.azure.resourcemanager.computefleet.fluent.OperationsClient;
import com.azure.resourcemanager.computefleet.fluent.models.OperationInner;
import com.azure.resourcemanager.computefleet.implementation.OperationImpl;
import com.azure.resourcemanager.computefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.computefleet.models.Operation;
import com.azure.resourcemanager.computefleet.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ComputeFleetManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ComputeFleetManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Operation> list() {
        PagedIterable<OperationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Operation> list(Context context) {
        PagedIterable<OperationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationImpl((OperationInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ComputeFleetManager manager() {
        return this.serviceManager;
    }
}

