/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DataDisk;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.OSDisk;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class StorageProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StorageProfile.class);
    @JsonProperty(value="imageReference")
    private ImageReference imageReference;
    @JsonProperty(value="osDisk")
    private OSDisk osDisk;
    @JsonProperty(value="dataDisks")
    private List<DataDisk> dataDisks;

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public StorageProfile withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public OSDisk osDisk() {
        return this.osDisk;
    }

    public StorageProfile withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public StorageProfile withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public void validate() {
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
    }
}

