/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.models.AutomaticOSUpgradeProperties;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.DisallowedConfiguration;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachineImageFeature;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineImageInner
extends VirtualMachineImageResourceInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineImageInner.class);
    @JsonProperty(value="properties.plan")
    private PurchasePlan plan;
    @JsonProperty(value="properties.osDiskImage")
    private OSDiskImage osDiskImage;
    @JsonProperty(value="properties.dataDiskImages")
    private List<DataDiskImage> dataDiskImages;
    @JsonProperty(value="properties.automaticOSUpgradeProperties")
    private AutomaticOSUpgradeProperties automaticOSUpgradeProperties;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGenerationTypes hyperVGeneration;
    @JsonProperty(value="properties.disallowed")
    private DisallowedConfiguration disallowed;
    @JsonProperty(value="properties.features")
    private List<VirtualMachineImageFeature> features;

    public PurchasePlan plan() {
        return this.plan;
    }

    public VirtualMachineImageInner withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    public OSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public VirtualMachineImageInner withOsDiskImage(OSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<DataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public VirtualMachineImageInner withDataDiskImages(List<DataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public AutomaticOSUpgradeProperties automaticOSUpgradeProperties() {
        return this.automaticOSUpgradeProperties;
    }

    public VirtualMachineImageInner withAutomaticOSUpgradeProperties(AutomaticOSUpgradeProperties automaticOSUpgradeProperties) {
        this.automaticOSUpgradeProperties = automaticOSUpgradeProperties;
        return this;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineImageInner withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public DisallowedConfiguration disallowed() {
        return this.disallowed;
    }

    public VirtualMachineImageInner withDisallowed(DisallowedConfiguration disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public List<VirtualMachineImageFeature> features() {
        return this.features;
    }

    public VirtualMachineImageInner withFeatures(List<VirtualMachineImageFeature> features) {
        this.features = features;
        return this;
    }

    @Override
    public VirtualMachineImageInner withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public VirtualMachineImageInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public VirtualMachineImageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public VirtualMachineImageInner withExtendedLocation(ExtendedLocation extendedLocation) {
        super.withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public VirtualMachineImageInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
        if (this.automaticOSUpgradeProperties() != null) {
            this.automaticOSUpgradeProperties().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
    }
}

