/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.DiskSku;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.ShareInfoElement;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DiskInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskInner.class);
    @JsonProperty(value="managedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String managedBy;
    @JsonProperty(value="managedByExtended", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> managedByExtended;
    @JsonProperty(value="sku")
    private DiskSku sku;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties.timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="properties.creationData")
    private CreationData creationData;
    @JsonProperty(value="properties.diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="properties.diskSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskSizeBytes;
    @JsonProperty(value="properties.uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="properties.encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.diskIOPSReadWrite")
    private Long diskIopsReadWrite;
    @JsonProperty(value="properties.diskMBpsReadWrite")
    private Long diskMBpsReadWrite;
    @JsonProperty(value="properties.diskIOPSReadOnly")
    private Long diskIopsReadOnly;
    @JsonProperty(value="properties.diskMBpsReadOnly")
    private Long diskMBpsReadOnly;
    @JsonProperty(value="properties.diskState", access=JsonProperty.Access.WRITE_ONLY)
    private DiskState diskState;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.maxShares")
    private Integer maxShares;
    @JsonProperty(value="properties.shareInfo", access=JsonProperty.Access.WRITE_ONLY)
    private List<ShareInfoElement> shareInfo;
    @JsonProperty(value="properties.networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="properties.diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="properties.tier")
    private String tier;
    @JsonProperty(value="properties.burstingEnabled")
    private Boolean burstingEnabled;
    @JsonProperty(value="properties.propertyUpdatesInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private PropertyUpdatesInProgress propertyUpdatesInProgress;
    @JsonProperty(value="properties.supportsHibernation")
    private Boolean supportsHibernation;
    @JsonProperty(value="properties.securityProfile")
    private DiskSecurityProfile securityProfile;

    public String managedBy() {
        return this.managedBy;
    }

    public List<String> managedByExtended() {
        return this.managedByExtended;
    }

    public DiskSku sku() {
        return this.sku;
    }

    public DiskInner withSku(DiskSku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public DiskInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public DiskInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public DiskInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskInner withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public DiskInner withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DiskInner withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public DiskInner withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public DiskInner withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskInner withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.diskIopsReadOnly;
    }

    public DiskInner withDiskIopsReadOnly(Long diskIopsReadOnly) {
        this.diskIopsReadOnly = diskIopsReadOnly;
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.diskMBpsReadOnly;
    }

    public DiskInner withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        this.diskMBpsReadOnly = diskMBpsReadOnly;
        return this;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public DiskInner withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public Integer maxShares() {
        return this.maxShares;
    }

    public DiskInner withMaxShares(Integer maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public List<ShareInfoElement> shareInfo() {
        return this.shareInfo;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskInner withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskInner withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public DiskInner withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public Boolean burstingEnabled() {
        return this.burstingEnabled;
    }

    public DiskInner withBurstingEnabled(Boolean burstingEnabled) {
        this.burstingEnabled = burstingEnabled;
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.propertyUpdatesInProgress;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskInner withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public DiskInner withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiskInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiskInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.shareInfo() != null) {
            this.shareInfo().forEach(e -> e.validate());
        }
        if (this.propertyUpdatesInProgress() != null) {
            this.propertyUpdatesInProgress().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }
}

