/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunCommandParameterDefinition
implements JsonSerializable<RunCommandParameterDefinition> {
    private String name;
    private String type;
    private String defaultValue;
    private Boolean required;
    private static final ClientLogger LOGGER = new ClientLogger(RunCommandParameterDefinition.class);

    public String name() {
        return this.name;
    }

    public RunCommandParameterDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public RunCommandParameterDefinition withType(String type) {
        this.type = type;
        return this;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public RunCommandParameterDefinition withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public RunCommandParameterDefinition withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model RunCommandParameterDefinition"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model RunCommandParameterDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeBooleanField("required", this.required);
        return jsonWriter.writeEndObject();
    }

    public static RunCommandParameterDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (RunCommandParameterDefinition)jsonReader.readObject(reader -> {
            RunCommandParameterDefinition deserializedRunCommandParameterDefinition = new RunCommandParameterDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.type = reader.getString();
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.defaultValue = reader.getString();
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.required = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunCommandParameterDefinition;
        });
    }
}

