/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.provider.IdentifierProvider;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import com.azure.resourcemanager.compute.implementation.ProximityPlacementGroupImpl;
import com.azure.resourcemanager.compute.implementation.VMSSPatchPayload;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetExtensionImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetMsiHandler;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetSkuImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetUnmanagedDataDiskImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetVMsImpl;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.BootDiagnostics;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.DiffDiskOptions;
import com.azure.resourcemanager.compute.models.DiffDiskPlacement;
import com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.KnownLinuxVirtualMachineImage;
import com.azure.resourcemanager.compute.models.KnownWindowsVirtualMachineImage;
import com.azure.resourcemanager.compute.models.LinuxConfiguration;
import com.azure.resourcemanager.compute.models.NetworkApiVersion;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.OrchestrationMode;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroup;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.RunCommandResult;
import com.azure.resourcemanager.compute.models.SshConfiguration;
import com.azure.resourcemanager.compute.models.SshPublicKey;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.UpgradeMode;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VaultSecretGroup;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetDataDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetExtension;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetExtensionProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIpConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetManagedDiskParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetOSDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetOSProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetSku;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetSkuTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetStorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdate;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMs;
import com.azure.resourcemanager.compute.models.WinRMConfiguration;
import com.azure.resourcemanager.compute.models.WinRMListener;
import com.azure.resourcemanager.compute.models.WindowsConfiguration;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.models.ApplicationSecurityGroup;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancerPrivateFrontend;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.VirtualMachineScaleSetNetworkInterface;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class VirtualMachineScaleSetImpl
extends GroupableParentResourceImpl<VirtualMachineScaleSet, VirtualMachineScaleSetInner, VirtualMachineScaleSetImpl, ComputeManager>
implements VirtualMachineScaleSet,
VirtualMachineScaleSet.DefinitionManagedOrUnmanaged,
VirtualMachineScaleSet.DefinitionManaged,
VirtualMachineScaleSet.DefinitionUnmanaged,
VirtualMachineScaleSet.Update,
VirtualMachineScaleSet.DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
VirtualMachineScaleSet.DefinitionStages.WithUserAssignedManagedServiceIdentity,
VirtualMachineScaleSet.UpdateStages.WithSystemAssignedIdentityBasedAccessOrApply,
VirtualMachineScaleSet.UpdateStages.WithUserAssignedManagedServiceIdentity {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final IdentifierProvider namer;
    private boolean isMarketplaceLinuxImage = false;
    private String existingPrimaryNetworkSubnetNameToAssociate;
    private List<String> creatableStorageAccountKeys = new ArrayList<String>();
    private List<StorageAccount> existingStorageAccountsToAssociate = new ArrayList<StorageAccount>();
    private Map<String, VirtualMachineScaleSetExtension> extensions;
    private LoadBalancer primaryInternetFacingLoadBalancer;
    private LoadBalancer primaryInternalLoadBalancer;
    private boolean removePrimaryInternetFacingLoadBalancerOnUpdate;
    private boolean removePrimaryInternalLoadBalancerOnUpdate;
    private LoadBalancer primaryInternetFacingLoadBalancerToAttachOnUpdate;
    private LoadBalancer primaryInternalLoadBalancerToAttachOnUpdate;
    private List<String> primaryInternetFacingLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToRemoveOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternetFacingLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBBackendsToAddOnUpdate = new ArrayList<String>();
    private List<String> primaryInternalLBInboundNatPoolsToAddOnUpdate = new ArrayList<String>();
    private boolean isUnmanagedDiskSelected;
    private final ManagedDataDiskCollection managedDataDisks;
    VirtualMachineScaleSetMsiHandler virtualMachineScaleSetMsiHandler;
    private final BootDiagnosticsHandler bootDiagnosticsHandler;
    private String newProximityPlacementGroupName;
    private ProximityPlacementGroupType newProximityPlacementGroupType;
    private boolean removeOsProfile;
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetImpl.class);
    private boolean profileAttached = false;

    VirtualMachineScaleSetImpl(String name, VirtualMachineScaleSetInner innerModel, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager, AuthorizationManager authorizationManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.namer = ((ComputeManager)this.manager()).resourceManager().internalContext().createIdentifierProvider(this.name());
        this.managedDataDisks = new ManagedDataDiskCollection(this);
        this.virtualMachineScaleSetMsiHandler = new VirtualMachineScaleSetMsiHandler(authorizationManager, this);
        this.bootDiagnosticsHandler = new BootDiagnosticsHandler(this);
        this.newProximityPlacementGroupName = null;
        this.newProximityPlacementGroupType = null;
    }

    protected void initializeChildrenFromInner() {
        this.extensions = new HashMap<String, VirtualMachineScaleSetExtension>();
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().extensionProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().extensionProfile().extensions() != null) {
            for (VirtualMachineScaleSetExtensionInner inner : ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().extensionProfile().extensions()) {
                this.extensions.put(inner.name(), new VirtualMachineScaleSetExtensionImpl(inner, this));
            }
        }
    }

    @Override
    public VirtualMachineScaleSetVMs virtualMachines() {
        return new VirtualMachineScaleSetVMsImpl(this, ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSetVMs(), (ComputeManager)this.myManager);
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetSku> listAvailableSkus() {
        return PagedConverter.mapPage(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().listSkus(this.resourceGroupName(), this.name()), VirtualMachineScaleSetSkuImpl::new);
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().block();
    }

    @Override
    public Mono<Void> deallocateAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().deallocateAsync(this.resourceGroupName(), this.name(), null, null).map(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().block();
    }

    @Override
    public Mono<Void> powerOffAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().powerOffAsync(this.resourceGroupName(), this.name(), null, null);
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().restartAsync(this.resourceGroupName(), this.name(), null);
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().startAsync(this.resourceGroupName(), this.name(), null);
    }

    @Override
    public void reimage() {
        this.reimageAsync().block();
    }

    @Override
    public Mono<Void> reimageAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().reimageAsync(this.resourceGroupName(), this.name(), null);
    }

    @Override
    public RunCommandResult runPowerShellScriptInVMInstance(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runPowerShellScriptInVMInstance(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public Mono<RunCommandResult> runPowerShellScriptInVMInstanceAsync(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runPowerShellScriptInVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runShellScriptInVMInstance(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runShellScriptInVMInstance(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public Mono<RunCommandResult> runShellScriptInVMInstanceAsync(String vmId, List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runShellScriptInVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runCommandInVMInstance(String vmId, RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runCommandInVMInstance(this.resourceGroupName(), this.name(), vmId, inputCommand);
    }

    @Override
    public Mono<RunCommandResult> runCommandVMInstanceAsync(String vmId, RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachineScaleSets().runCommandVMInstanceAsync(this.resourceGroupName(), this.name(), vmId, inputCommand);
    }

    @Override
    public String computerNamePrefix() {
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().computerNamePrefix();
        }
        return null;
    }

    @Override
    public OperatingSystemTypes osType() {
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().osType();
        }
        return null;
    }

    @Override
    public CachingTypes osDiskCachingType() {
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().caching();
        }
        return null;
    }

    @Override
    public String osDiskName() {
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().name();
        }
        return null;
    }

    @Override
    public boolean isEphemeralOSDisk() {
        return this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().diffDiskSettings() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().diffDiskSettings().placement() != null;
    }

    @Override
    public UpgradeMode upgradeModel() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy() == null ? null : ((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy().mode();
    }

    @Override
    public boolean overProvisionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineScaleSetInner)((Object)this.innerModel())).overprovision());
    }

    @Override
    public VirtualMachineScaleSetSkuTypes sku() {
        return VirtualMachineScaleSetSkuTypes.fromSku(((VirtualMachineScaleSetInner)((Object)this.innerModel())).sku());
    }

    @Override
    public int capacity() {
        if (this.isVMProfileNotSet()) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Long)((VirtualMachineScaleSetInner)((Object)this.innerModel())).sku().capacity());
    }

    @Override
    public Network getPrimaryNetwork() throws IOException {
        VirtualMachineScaleSetIpConfiguration ipConfiguration = this.primaryNicDefaultIpConfiguration();
        if (ipConfiguration == null) {
            return null;
        }
        String subnetId = ipConfiguration.subnet().id();
        String virtualNetworkId = ResourceUtils.parentResourceIdFromResourceId((String)subnetId);
        return (Network)this.networkManager.networks().getById(virtualNetworkId);
    }

    @Override
    public LoadBalancer getPrimaryInternetFacingLoadBalancer() throws IOException {
        if (this.primaryInternetFacingLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailableAsync().block();
        }
        return this.primaryInternetFacingLoadBalancer;
    }

    @Override
    public Map<String, LoadBalancerBackend> listPrimaryInternetFacingLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIpConfiguration());
        }
        return new HashMap<String, LoadBalancerBackend>();
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternetFacingLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternetFacingLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIpConfiguration());
        }
        return new HashMap<String, LoadBalancerInboundNatPool>();
    }

    @Override
    public LoadBalancer getPrimaryInternalLoadBalancer() throws IOException {
        if (this.primaryInternalLoadBalancer == null) {
            this.loadCurrentPrimaryLoadBalancersIfAvailableAsync().block();
        }
        return this.primaryInternalLoadBalancer;
    }

    @Override
    public Map<String, LoadBalancerBackend> listPrimaryInternalLoadBalancerBackends() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getBackendsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIpConfiguration());
        }
        return new HashMap<String, LoadBalancerBackend>();
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> listPrimaryInternalLoadBalancerInboundNatPools() throws IOException {
        if (this.getPrimaryInternalLoadBalancer() != null) {
            return VirtualMachineScaleSetImpl.getInboundNatPoolsAssociatedWithIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIpConfiguration());
        }
        return new HashMap<String, LoadBalancerInboundNatPool>();
    }

    @Override
    public List<String> primaryPublicIpAddressIds() throws IOException {
        LoadBalancer loadBalancer = this.getPrimaryInternetFacingLoadBalancer();
        if (loadBalancer != null) {
            return loadBalancer.publicIpAddressIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> vhdContainers() {
        if (this.storageProfile() != null && this.storageProfile().osDisk() != null && this.storageProfile().osDisk().vhdContainers() != null) {
            return this.storageProfile().osDisk().vhdContainers();
        }
        return new ArrayList<String>();
    }

    @Override
    public VirtualMachineScaleSetStorageProfile storageProfile() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile();
        }
        return null;
    }

    @Override
    public VirtualMachineScaleSetNetworkProfile networkProfile() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().networkProfile();
        }
        return null;
    }

    @Override
    public Map<String, VirtualMachineScaleSetExtension> extensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    public VirtualMachinePriorityTypes virtualMachinePriority() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().priority();
        }
        return null;
    }

    @Override
    public BillingProfile billingProfile() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().billingProfile();
        }
        return null;
    }

    @Override
    public VirtualMachineScaleSetPublicIpAddressConfiguration virtualMachinePublicIpConfig() {
        VirtualMachineScaleSetIpConfiguration nicConfig = this.primaryNicDefaultIpConfiguration();
        if (nicConfig == null) {
            return null;
        }
        return nicConfig.publicIpAddressConfiguration();
    }

    @Override
    public VirtualMachineEvictionPolicyTypes virtualMachineEvictionPolicy() {
        if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().evictionPolicy();
        }
        return null;
    }

    @Override
    public boolean isIpForwardingEnabled() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig == null || nicConfig.enableIpForwarding() == null) {
            return false;
        }
        return nicConfig.enableIpForwarding();
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig == null || nicConfig.enableAcceleratedNetworking() == null) {
            return false;
        }
        return nicConfig.enableAcceleratedNetworking();
    }

    @Override
    public String networkSecurityGroupId() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig != null && nicConfig.networkSecurityGroup() != null) {
            return nicConfig.networkSecurityGroup().id();
        }
        return null;
    }

    @Override
    public boolean isSinglePlacementGroupEnabled() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).singlePlacementGroup() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).singlePlacementGroup();
        }
        return false;
    }

    @Override
    public List<String> applicationGatewayBackendAddressPoolsIds() {
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig == null) {
            return Collections.emptyList();
        }
        List<SubResource> backendPools = nicIpConfig.applicationGatewayBackendAddressPools();
        ArrayList<String> result = new ArrayList<String>();
        if (backendPools != null) {
            for (SubResource backendPool : backendPools) {
                result.add(backendPool.id());
            }
        }
        return result;
    }

    @Override
    public List<String> applicationSecurityGroupIds() {
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<String> asgIds = new ArrayList<String>();
        if (nicIpConfig.applicationSecurityGroups() != null) {
            for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
                asgIds.add(asg.id());
            }
        }
        return asgIds;
    }

    @Override
    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).doNotRunExtensionsOnOverprovisionedVMs();
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).proximityPlacementGroup() == null) {
            return null;
        }
        ResourceId id = ResourceId.fromString((String)((VirtualMachineScaleSetInner)((Object)this.innerModel())).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public AdditionalCapabilities additionalCapabilities() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).additionalCapabilities();
    }

    @Override
    public Plan plan() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).plan();
    }

    @Override
    public OrchestrationMode orchestrationMode() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).orchestrationMode() == null ? OrchestrationMode.UNIFORM : ((VirtualMachineScaleSetInner)((Object)this.innerModel())).orchestrationMode();
    }

    @Override
    public VirtualMachineScaleSetNetworkInterface getNetworkInterfaceByInstanceId(String instanceId, String name) {
        return this.networkManager.networkInterfaces().getByVirtualMachineScaleSetInstanceId(this.resourceGroupName(), this.name(), instanceId, name);
    }

    @Override
    public Mono<VirtualMachineScaleSetNetworkInterface> getNetworkInterfaceByInstanceIdAsync(String instanceId, String name) {
        return this.networkManager.networkInterfaces().getByVirtualMachineScaleSetInstanceIdAsync(this.resourceGroupName(), this.name(), instanceId, name);
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetNetworkInterface> listNetworkInterfaces() {
        return this.networkManager.networkInterfaces().listByVirtualMachineScaleSet(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetNetworkInterface> listNetworkInterfacesByInstanceId(String virtualMachineInstanceId) {
        return this.networkManager.networkInterfaces().listByVirtualMachineScaleSetInstanceId(this.resourceGroupName(), this.name(), virtualMachineInstanceId);
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetNetworkInterface> listNetworkInterfacesByInstanceIdAsync(String virtualMachineInstanceId) {
        return this.networkManager.networkInterfaces().listByVirtualMachineScaleSetInstanceIdAsync(this.resourceGroupName(), this.name(), virtualMachineInstanceId);
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSkuTypes skuType) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withSku(skuType.sku());
        this.initVMProfileIfNecessary();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withFlexibleOrchestrationMode() {
        return this.withFlexibleOrchestrationMode(1);
    }

    @Override
    public VirtualMachineScaleSetImpl withFlexibleOrchestrationMode(int faultDomainCount) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withOrchestrationMode(OrchestrationMode.FLEXIBLE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withPlatformFaultDomainCount(faultDomainCount);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSku(VirtualMachineScaleSetSku sku) {
        return this.withSku(sku.skuType());
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryNetworkSubnet(Network network, String subnetName) {
        this.initVMProfileIfNecessary();
        this.existingPrimaryNetworkSubnetNameToAssociate = VirtualMachineScaleSetImpl.mergePath(network.id(), "subnets", subnetName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryInternetFacingLoadBalancer(LoadBalancer loadBalancer) {
        if (loadBalancer.publicIpAddressIds().isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter loadBalancer must be an Internet facing load balancer"));
        }
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            this.primaryInternetFacingLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancer, this.primaryNicDefaultIpConfiguration());
        } else {
            this.primaryInternetFacingLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIpConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIpConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternetFacingLoadBalancerInboundNatPools(String ... natPoolNames) {
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIpConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIpConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingPrimaryInternalLoadBalancer(LoadBalancer loadBalancer) {
        if (!loadBalancer.publicIpAddressIds().isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Parameter loadBalancer must be an internal load balancer"));
        }
        String lbNetworkId = null;
        for (LoadBalancerPrivateFrontend frontEnd : loadBalancer.privateFrontends().values()) {
            if (frontEnd.networkId() == null) continue;
            lbNetworkId = frontEnd.networkId();
        }
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            String vmNICNetworkId = ResourceUtils.parentResourceIdFromResourceId((String)this.existingPrimaryNetworkSubnetNameToAssociate);
            if (!vmNICNetworkId.equalsIgnoreCase(lbNetworkId)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNICNetworkId + "''" + lbNetworkId));
            }
            this.primaryInternalLoadBalancer = loadBalancer;
            VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancer, this.primaryNicDefaultIpConfiguration());
        } else {
            String vmNicVnetId = ResourceUtils.parentResourceIdFromResourceId((String)this.primaryNicDefaultIpConfiguration().subnet().id());
            if (!vmNicVnetId.equalsIgnoreCase(lbNetworkId)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Virtual network associated with scale set virtual machines and internal load balancer must be same. '" + vmNicVnetId + "''" + lbNetworkId));
            }
            this.primaryInternalLoadBalancerToAttachOnUpdate = loadBalancer;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIpConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIpConfiguration();
            VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, backendNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToAddOnUpdate, backendNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPrimaryInternalLoadBalancerInboundNatPools(String ... natPoolNames) {
        this.initVMProfileIfNecessary();
        if (this.isInCreateMode()) {
            VirtualMachineScaleSetIpConfiguration defaultPrimaryIpConfig = this.primaryNicDefaultIpConfiguration();
            VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, defaultPrimaryIpConfig);
            VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), defaultPrimaryIpConfig, natPoolNames);
        } else {
            VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToAddOnUpdate, natPoolNames);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternalLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancer() {
        if (this.isInUpdateMode()) {
            this.removePrimaryInternetFacingLoadBalancerOnUpdate = true;
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerBackends(String ... backendNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBBackendsToRemoveOnUpdate, backendNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternetFacingLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutPrimaryInternalLoadBalancerNatPools(String ... natPoolNames) {
        VirtualMachineScaleSetImpl.addToList(this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate, natPoolNames);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withGeneralizedWindowsCustomImage(String customImageId) {
        this.initVMProfileIfNecessary();
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecializedWindowsCustomImage(String customImageId) {
        this.withGeneralizedWindowsCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredWindowsImage(String imageUrl) {
        this.initVMProfileIfNecessary();
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineScaleSetImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku).withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().withImageReference(imageReference);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withGeneralizedLinuxCustomImage(String customImageId) {
        this.initVMProfileIfNecessary();
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSpecializedLinuxCustomImage(String customImageId) {
        this.withGeneralizedLinuxCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withStoredLinuxImage(String imageUrl) {
        this.initVMProfileIfNecessary();
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdminUsername(String adminUserName) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withRootUsername(String adminUserName) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdminPassword(String password) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withRootPassword(String password) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSsh(String publicKeyData) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKey>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKey sshPublicKey = new SshPublicKey();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVMAgent() {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutVMAgent() {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAutoUpdate() {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutAutoUpdate() {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withTimeZone(String timeZone) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withWinRM(WinRMListener listener) {
        this.initVMProfileIfNecessary();
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskCaching(CachingTypes cachingType) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskName(String name) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withName(name);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withEphemeralOSDisk() {
        if (this.isVMProfileNotSet()) {
            return this;
        }
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetOSDisk disk = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk();
        disk.withCaching(CachingTypes.READ_ONLY);
        disk.withDiffDiskSettings(new DiffDiskSettings());
        disk.diffDiskSettings().withOption(DiffDiskOptions.LOCAL);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withComputerNamePrefix(String namePrefix) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withComputerNamePrefix(namePrefix);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withUpgradeMode(UpgradeMode upgradeMode) {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withUpgradePolicy(new UpgradePolicy());
        }
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy().withMode(upgradeMode);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvision(boolean enabled) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withOverprovision(enabled);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOverProvisioning() {
        return this.withOverProvision(true);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutOverProvisioning() {
        return this.withOverProvision(false);
    }

    @Override
    public VirtualMachineScaleSetImpl withCapacity(long capacity) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineScaleSetImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        this.creatableStorageAccountKeys.add(this.addDependency(creatable));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountsToAssociate.add(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withCustomData(String base64EncodedCustomData) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withCustomData(base64EncodedCustomData);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSecrets(List<VaultSecretGroup> secrets) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withSecrets(secrets);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSecrets() {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile().withSecrets(new ArrayList<VaultSecretGroup>());
        return this;
    }

    public VirtualMachineScaleSetExtensionImpl defineNewExtension(String name) {
        return new VirtualMachineScaleSetExtensionImpl(new VirtualMachineScaleSetExtensionInner().withName(name), this);
    }

    protected VirtualMachineScaleSetImpl withExtension(VirtualMachineScaleSetExtensionImpl extension) {
        this.extensions.put(extension.name(), extension);
        return this;
    }

    @Override
    public VirtualMachineScaleSetExtensionImpl updateExtension(String name) {
        return (VirtualMachineScaleSetExtensionImpl)this.extensions.get(name);
    }

    @Override
    public VirtualMachineScaleSetImpl withoutExtension(String name) {
        if (this.extensions.containsKey(name)) {
            this.extensions.remove(name);
        }
        return this;
    }

    @Override
    public boolean isManagedDiskEnabled() {
        if (this.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            return false;
        }
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile();
        if (this.isOsDiskFromCustomImage(storageProfile)) {
            return true;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            return false;
        }
        if (this.isOSDiskFromPlatformImage(storageProfile) && this.isUnmanagedDiskSelected) {
            return false;
        }
        if (this.isInCreateMode()) {
            return true;
        }
        List<String> vhdContainers = storageProfile.osDisk().vhdContainers();
        return vhdContainers == null || vhdContainers.size() == 0;
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((VirtualMachineScaleSetInner)((Object)this.innerModel())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((VirtualMachineScaleSetInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public boolean isBootDiagnosticsEnabled() {
        return this.bootDiagnosticsHandler.isBootDiagnosticsEnabled();
    }

    @Override
    public String bootDiagnosticsStorageUri() {
        return this.bootDiagnosticsHandler.bootDiagnosticsStorageUri();
    }

    @Override
    public StorageAccountTypes managedOSDiskStorageAccountType() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().managedDisk() != null) {
            return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().managedDisk().storageAccountType();
        }
        return null;
    }

    @Override
    public VirtualMachineScaleSetImpl withUnmanagedDisks() {
        this.isUnmanagedDiskSelected = true;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(-1).withDiskSizeGB(sizeInGB));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        this.throwIfManagedDiskDisabled("This virtual machine scale set is based on un-managed disk(s), both un-managed and managed cannot exists together in a virtual machine scale set");
        VirtualMachineScaleSetManagedDiskParameters managedDiskParameters = new VirtualMachineScaleSetManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.implicitDisksToAssociate.add(new VirtualMachineScaleSetDataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutDataDisk(int lun) {
        if (!this.isManagedDiskEnabled()) {
            return this;
        }
        this.managedDataDisks.diskLunsToRemove.add(lun);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun) {
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType) {
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        VirtualMachineScaleSetManagedDiskParameters managedDiskParameters = new VirtualMachineScaleSetManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.newDisksFromImage.add(new VirtualMachineScaleSetDataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withOSDiskStorageAccountType(StorageAccountTypes accountType) {
        this.initVMProfileIfNecessary();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters().withStorageAccountType(accountType));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDataDiskDefaultCachingType(CachingTypes cachingType) {
        this.managedDataDisks.setDefaultCachingType(cachingType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDataDiskDefaultStorageAccountType(StorageAccountTypes storageAccountType) {
        this.managedDataDisks.setDefaultStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedManagedServiceIdentity() {
        this.virtualMachineScaleSetMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSystemAssignedManagedServiceIdentity() {
        this.virtualMachineScaleSetMsiHandler.withoutLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.virtualMachineScaleSetMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole asRole) {
        this.virtualMachineScaleSetMsiHandler.withAccessToCurrentResourceGroup(asRole);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessTo(String scope, String roleDefinitionId) {
        this.virtualMachineScaleSetMsiHandler.withAccessTo(scope, roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.virtualMachineScaleSetMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.virtualMachineScaleSetMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.virtualMachineScaleSetMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutUserAssignedManagedServiceIdentity(String identityId) {
        this.virtualMachineScaleSetMsiHandler.withoutExternalManagedServiceIdentity(identityId);
        return this;
    }

    protected void beforeCreating() {
        this.setExtensions();
    }

    protected Mono<VirtualMachineScaleSetInner> createInner() {
        if (this.orchestrationMode() == OrchestrationMode.FLEXIBLE && this.isVMProfileNotSet()) {
            return this.createInnerNoProfile();
        }
        if (this.shouldSetProfileDefaults()) {
            this.setOSProfileDefaults();
            this.setOSDiskDefault();
        }
        this.setPrimaryIpConfigurationSubnet();
        return this.setPrimaryIpConfigurationBackendsAndInboundNatPoolsAsync().flatMap(virtualMachineScaleSet -> {
            if (this.isManagedDiskEnabled()) {
                this.managedDataDisks.setDataDisksDefaults();
            } else {
                List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)((Object)this.innerModel()))).virtualMachineProfile().storageProfile().dataDisks();
                VirtualMachineScaleSetUnmanagedDataDiskImpl.setDataDisksDefaults(dataDisks, this.name());
            }
            this.handleUnManagedOSDiskContainers();
            this.bootDiagnosticsHandler.handleDiagnosticsSettings();
            this.virtualMachineScaleSetMsiHandler.processCreatedExternalIdentities();
            this.virtualMachineScaleSetMsiHandler.handleExternalIdentities();
            this.adjustProfileForFlexibleMode();
            return this.createNewProximityPlacementGroupAsync().then(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualMachineScaleSetInner)((Object)((Object)this.innerModel()))));
        });
    }

    protected void afterCreating() {
        this.clearCachedProperties();
        this.virtualMachineScaleSetMsiHandler.clear();
    }

    public Mono<VirtualMachineScaleSet> updateResourceAsync() {
        VirtualMachineScaleSetImpl self = this;
        if (this.orchestrationMode() == OrchestrationMode.FLEXIBLE && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            return this.updateResourceAsyncNoProfile(self);
        }
        this.setExtensions();
        if (this.shouldSetProfileDefaults()) {
            this.setOSProfileDefaults();
            this.setOSDiskDefault();
        }
        this.setPrimaryIpConfigurationSubnet();
        return this.setPrimaryIpConfigurationBackendsAndInboundNatPoolsAsync().map(virtualMachineScaleSet -> {
            if (this.isManagedDiskEnabled()) {
                this.managedDataDisks.setDataDisksDefaults();
            } else if (this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)((Object)this.innerModel()))).virtualMachineProfile() != null) {
                List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)((Object)this.innerModel()))).virtualMachineProfile().storageProfile().dataDisks();
                VirtualMachineScaleSetUnmanagedDataDiskImpl.setDataDisksDefaults(dataDisks, this.name());
            }
            this.handleUnManagedOSDiskContainers();
            this.bootDiagnosticsHandler.handleDiagnosticsSettings();
            this.virtualMachineScaleSetMsiHandler.processCreatedExternalIdentities();
            this.adjustProfileForFlexibleMode();
            VirtualMachineScaleSetUpdate updateParameter = VMSSPatchPayload.preparePatchPayload(this);
            this.virtualMachineScaleSetMsiHandler.handleExternalIdentities(updateParameter);
            return updateParameter;
        }).flatMap(updateParameter -> ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().updateAsync(this.resourceGroupName(), this.name(), (VirtualMachineScaleSetUpdate)updateParameter).map(vmssInner -> {
            this.setInner(vmssInner);
            self.clearCachedProperties();
            self.initializeChildrenFromInner();
            self.virtualMachineScaleSetMsiHandler.clear();
            return self;
        }));
    }

    public Mono<VirtualMachineScaleSet> refreshAsync() {
        return super.refreshAsync().map(scaleSet -> {
            VirtualMachineScaleSetImpl impl = (VirtualMachineScaleSetImpl)scaleSet;
            impl.clearCachedProperties();
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<VirtualMachineScaleSetInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private boolean isVMProfileNotSet() {
        return ((VirtualMachineScaleSetInner)((Object)this.innerModel())).sku() == null;
    }

    private void adjustProfileForFlexibleMode() {
        if (this.orchestrationMode() == OrchestrationMode.FLEXIBLE) {
            if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations() != null) {
                ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations().forEach(virtualMachineScaleSetNetworkConfiguration -> {
                    if (virtualMachineScaleSetNetworkConfiguration.ipConfigurations() != null) {
                        virtualMachineScaleSetNetworkConfiguration.ipConfigurations().forEach(virtualMachineScaleSetIpConfiguration -> virtualMachineScaleSetIpConfiguration.withLoadBalancerInboundNatPools(null));
                    }
                });
            }
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withUpgradePolicy(null).virtualMachineProfile().networkProfile().withNetworkApiVersion(NetworkApiVersion.TWO_ZERO_TWO_ZERO_ONE_ONE_ZERO_ONE);
        }
    }

    private Mono<VirtualMachineScaleSetInner> createInnerNoProfile() {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withVirtualMachineProfile(null);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualMachineScaleSetInner)((Object)this.innerModel()));
    }

    private Mono<VirtualMachineScaleSet> updateResourceAsyncNoProfile(VirtualMachineScaleSetImpl self) {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachineScaleSets().updateAsync(this.resourceGroupName(), this.name(), VMSSPatchPayload.preparePatchPayload(this)).map(vmssInner -> {
            this.setInner(vmssInner);
            self.clearCachedProperties();
            self.initializeChildrenFromInner();
            self.virtualMachineScaleSetMsiHandler.clear();
            return self;
        });
    }

    private void initVMProfileIfNecessary() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withVirtualMachineProfile(this.initDefaultVMProfile());
            this.profileAttached = true;
        }
    }

    private VirtualMachineScaleSetVMProfile initDefaultVMProfile() {
        VirtualMachineScaleSetImpl impl = (VirtualMachineScaleSetImpl)((ComputeManager)this.manager()).virtualMachineScaleSets().define(this.name());
        if (this.orchestrationMode() == OrchestrationMode.FLEXIBLE) {
            if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).platformFaultDomainCount() != null) {
                impl.withFlexibleOrchestrationMode(((VirtualMachineScaleSetInner)((Object)this.innerModel())).platformFaultDomainCount());
            } else {
                impl.withFlexibleOrchestrationMode();
            }
        }
        return ((VirtualMachineScaleSetInner)((Object)impl.innerModel())).virtualMachineProfile();
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    private void setOSProfileDefaults() {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).sku().capacity() == null) {
            this.withCapacity(2L);
        }
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).upgradePolicy().mode() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withUpgradePolicy(new UpgradePolicy().withMode(UpgradeMode.AUTOMATIC));
        }
        VirtualMachineScaleSetOSProfile osProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().osProfile();
        VirtualMachineScaleSetOSDisk osDisk = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk();
        if (!this.removeOsProfile && this.isOSDiskFromImage(osDisk)) {
            if (this.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
                if (osProfile.linuxConfiguration() == null) {
                    osProfile.withLinuxConfiguration(new LinuxConfiguration());
                }
                osProfile.linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
            }
            if (this.computerNamePrefix() == null) {
                if (this.name().matches("[0-9]+")) {
                    this.withComputerNamePrefix(this.namer.getRandomName("vmss-vm", 12));
                } else if (this.name().length() <= 12) {
                    this.withComputerNamePrefix(this.name() + "-vm");
                } else {
                    this.withComputerNamePrefix(this.namer.getRandomName("vmss-vm", 12));
                }
            }
        } else {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withOsProfile(null);
        }
    }

    private void setOSDiskDefault() {
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile();
        VirtualMachineScaleSetOSDisk osDisk = storageProfile.osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (this.isManagedDiskEnabled()) {
                if (osDisk.managedDisk() == null) {
                    osDisk.withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters());
                }
                if (osDisk.managedDisk().storageAccountType() == null) {
                    osDisk.managedDisk().withStorageAccountType(StorageAccountTypes.STANDARD_LRS);
                }
                osDisk.withVhdContainers(null);
            } else {
                osDisk.withManagedDisk(null);
                if (osDisk.name() == null) {
                    this.withOSDiskName(this.name() + "-os-disk");
                }
            }
        }
        if (this.osDiskCachingType() == null) {
            this.withOSDiskCaching(CachingTypes.READ_WRITE);
        }
    }

    private boolean shouldSetProfileDefaults() {
        return this.isInCreateMode() || this.orchestrationMode() == OrchestrationMode.FLEXIBLE && this.profileAttached;
    }

    private void setExtensions() {
        if (this.extensions.size() > 0 && this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() != null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withExtensionProfile(new VirtualMachineScaleSetExtensionProfile()).extensionProfile().withExtensions(this.innersFromWrappers(this.extensions.values()));
        }
    }

    public void beforeGroupCreateOrUpdate() {
        this.prepareOSDiskContainers();
        this.bootDiagnosticsHandler.prepare();
    }

    protected void prepareOSDiskContainers() {
        if (this.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null || this.isManagedDiskEnabled()) {
            return;
        }
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile();
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            return;
        }
        if (this.isInCreateMode() && this.creatableStorageAccountKeys.isEmpty() && this.existingStorageAccountsToAssociate.isEmpty()) {
            String accountName = this.namer.getRandomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(accountName)).withRegion(this.regionName())).withNewResourceGroup(this.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(accountName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKeys.add(this.addDependency(storageAccountCreatable));
        }
    }

    private void handleUnManagedOSDiskContainers() {
        if (this.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            return;
        }
        VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile();
        if (this.isManagedDiskEnabled()) {
            storageProfile.osDisk().withVhdContainers(null);
            return;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            storageProfile.osDisk().vhdContainers().clear();
            return;
        }
        String containerName = null;
        Iterator<String> iterator = storageProfile.osDisk().vhdContainers().iterator();
        if (iterator.hasNext()) {
            String containerUrl = iterator.next();
            containerName = containerUrl.substring(containerUrl.lastIndexOf("/") + 1);
        }
        if (containerName == null) {
            containerName = "vhds";
        }
        if (this.isInCreateMode() && this.creatableStorageAccountKeys.isEmpty() && this.existingStorageAccountsToAssociate.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Expected storage account(s) for VMSS OS disk containers not found"));
        }
        for (String storageAccountKey : this.creatableStorageAccountKeys) {
            StorageAccount storageAccount = (StorageAccount)this.taskResult(storageAccountKey);
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        for (StorageAccount storageAccount : this.existingStorageAccountsToAssociate) {
            storageProfile.osDisk().vhdContainers().add(VirtualMachineScaleSetImpl.mergePath(storageAccount.endPoints().primary().blob(), containerName));
        }
        this.creatableStorageAccountKeys.clear();
        this.existingStorageAccountsToAssociate.clear();
    }

    private void setPrimaryIpConfigurationSubnet() {
        if (this.isInUpdateMode()) {
            return;
        }
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration ipConfig = this.primaryNicDefaultIpConfiguration();
        ipConfig.withSubnet(new ApiEntityReference().withId(this.existingPrimaryNetworkSubnetNameToAssociate));
        this.existingPrimaryNetworkSubnetNameToAssociate = null;
    }

    private Mono<VirtualMachineScaleSetImpl> setPrimaryIpConfigurationBackendsAndInboundNatPoolsAsync() {
        if (this.isInCreateMode()) {
            return Mono.just((Object)this);
        }
        try {
            return this.loadCurrentPrimaryLoadBalancersIfAvailableAsync().map(virtualMachineScaleSet -> {
                this.initVMProfileIfNecessary();
                VirtualMachineScaleSetIpConfiguration primaryIpConfig = this.primaryNicDefaultIpConfiguration();
                if (this.primaryInternetFacingLoadBalancer != null) {
                    VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToRemoveOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancer.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
                }
                if (this.primaryInternalLoadBalancer != null) {
                    VirtualMachineScaleSetImpl.removeBackendsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToRemoveOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.removeInboundNatPoolsFromIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.toArray(new String[0]));
                    VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancer.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
                }
                if (this.removePrimaryInternetFacingLoadBalancerOnUpdate && this.primaryInternetFacingLoadBalancer != null) {
                    VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
                }
                if (this.removePrimaryInternalLoadBalancerOnUpdate && this.primaryInternalLoadBalancer != null) {
                    VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
                }
                if (this.primaryInternetFacingLoadBalancerToAttachOnUpdate != null) {
                    if (this.primaryInternetFacingLoadBalancer != null) {
                        VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancer, primaryIpConfig);
                    }
                    VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                    if (!this.primaryInternetFacingLBBackendsToAddOnUpdate.isEmpty()) {
                        VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                        VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBBackendsToAddOnUpdate.toArray(new String[0]));
                    }
                    if (!this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                        VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate, primaryIpConfig);
                        VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternetFacingLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
                    }
                }
                if (this.primaryInternalLoadBalancerToAttachOnUpdate != null) {
                    if (this.primaryInternalLoadBalancer != null) {
                        VirtualMachineScaleSetImpl.removeLoadBalancerAssociationFromIpConfiguration(this.primaryInternalLoadBalancer, primaryIpConfig);
                    }
                    VirtualMachineScaleSetImpl.associateLoadBalancerToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                    if (!this.primaryInternalLBBackendsToAddOnUpdate.isEmpty()) {
                        VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                        VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBBackendsToAddOnUpdate.toArray(new String[0]));
                    }
                    if (!this.primaryInternalLBInboundNatPoolsToAddOnUpdate.isEmpty()) {
                        VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate, primaryIpConfig);
                        VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(this.primaryInternalLoadBalancerToAttachOnUpdate.id(), primaryIpConfig, this.primaryInternalLBInboundNatPoolsToAddOnUpdate.toArray(new String[0]));
                    }
                }
                this.removePrimaryInternetFacingLoadBalancerOnUpdate = false;
                this.removePrimaryInternalLoadBalancerOnUpdate = false;
                this.primaryInternetFacingLoadBalancerToAttachOnUpdate = null;
                this.primaryInternalLoadBalancerToAttachOnUpdate = null;
                this.primaryInternetFacingLBBackendsToRemoveOnUpdate.clear();
                this.primaryInternetFacingLBInboundNatPoolsToRemoveOnUpdate.clear();
                this.primaryInternalLBBackendsToRemoveOnUpdate.clear();
                this.primaryInternalLBInboundNatPoolsToRemoveOnUpdate.clear();
                this.primaryInternetFacingLBBackendsToAddOnUpdate.clear();
                this.primaryInternetFacingLBInboundNatPoolsToAddOnUpdate.clear();
                this.primaryInternalLBBackendsToAddOnUpdate.clear();
                this.primaryInternalLBInboundNatPoolsToAddOnUpdate.clear();
                return this;
            });
        }
        catch (IOException ioException) {
            throw this.logger.logExceptionAsError(new RuntimeException(ioException));
        }
    }

    private void clearCachedProperties() {
        this.primaryInternetFacingLoadBalancer = null;
        this.primaryInternalLoadBalancer = null;
        this.profileAttached = false;
    }

    private Mono<VirtualMachineScaleSetImpl> loadCurrentPrimaryLoadBalancersIfAvailableAsync() throws IOException {
        Mono self = Mono.just((Object)this);
        if (this.primaryInternetFacingLoadBalancer != null && this.primaryInternalLoadBalancer != null) {
            return self;
        }
        String firstLoadBalancerId = null;
        VirtualMachineScaleSetIpConfiguration ipConfig = this.primaryNicDefaultIpConfiguration();
        if (ipConfig == null) {
            return self;
        }
        if (!ipConfig.loadBalancerBackendAddressPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)ipConfig.loadBalancerBackendAddressPools().get(0).id());
        }
        if (firstLoadBalancerId == null && !ipConfig.loadBalancerInboundNatPools().isEmpty()) {
            firstLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)ipConfig.loadBalancerInboundNatPools().get(0).id());
        }
        if (firstLoadBalancerId == null) {
            return self;
        }
        self = self.concatWith((Publisher)Mono.just(firstLoadBalancerId).flatMap(id -> this.networkManager.loadBalancers().getByIdAsync(id).map(loadBalancer1 -> {
            if (loadBalancer1.publicIpAddressIds() != null && loadBalancer1.publicIpAddressIds().size() > 0) {
                this.primaryInternetFacingLoadBalancer = loadBalancer1;
            } else {
                this.primaryInternalLoadBalancer = loadBalancer1;
            }
            return this;
        }))).last();
        String secondLoadBalancerId = null;
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (subResource.id().toLowerCase(Locale.ROOT).startsWith(firstLoadBalancerId.toLowerCase(Locale.ROOT))) continue;
            secondLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)subResource.id());
            break;
        }
        if (secondLoadBalancerId == null) {
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (subResource.id().toLowerCase(Locale.ROOT).startsWith(firstLoadBalancerId.toLowerCase(Locale.ROOT))) continue;
                secondLoadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)subResource.id());
                break;
            }
        }
        if (secondLoadBalancerId == null) {
            return self;
        }
        return self.concatWith((Publisher)Mono.just(secondLoadBalancerId).flatMap(id -> this.networkManager.loadBalancers().getByIdAsync(id).map(loadBalancer2 -> {
            if (loadBalancer2.publicIpAddressIds() != null && loadBalancer2.publicIpAddressIds().size() > 0) {
                this.primaryInternetFacingLoadBalancer = loadBalancer2;
            } else {
                this.primaryInternalLoadBalancer = loadBalancer2;
            }
            return this;
        }))).last();
    }

    private VirtualMachineScaleSetIpConfiguration primaryNicDefaultIpConfiguration() {
        if (this.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            return null;
        }
        List<VirtualMachineScaleSetNetworkConfiguration> nicConfigurations = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations();
        for (VirtualMachineScaleSetNetworkConfiguration nicConfiguration : nicConfigurations) {
            if (!nicConfiguration.primary().booleanValue() || nicConfiguration.ipConfigurations().size() <= 0) continue;
            VirtualMachineScaleSetIpConfiguration ipConfig = nicConfiguration.ipConfigurations().get(0);
            if (ipConfig.loadBalancerBackendAddressPools() == null) {
                ipConfig.withLoadBalancerBackendAddressPools(new ArrayList<SubResource>());
            }
            if (ipConfig.loadBalancerInboundNatPools() == null) {
                ipConfig.withLoadBalancerInboundNatPools(new ArrayList<SubResource>());
            }
            return ipConfig;
        }
        throw this.logger.logExceptionAsError(new RuntimeException("Could not find the primary nic configuration or an IP configuration in it"));
    }

    private VirtualMachineScaleSetNetworkConfiguration primaryNicConfiguration() {
        if (this.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile() == null) {
            return null;
        }
        List<VirtualMachineScaleSetNetworkConfiguration> nicConfigurations = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().networkProfile().networkInterfaceConfigurations();
        for (VirtualMachineScaleSetNetworkConfiguration nicConfiguration : nicConfigurations) {
            if (!nicConfiguration.primary().booleanValue()) continue;
            return nicConfiguration;
        }
        throw this.logger.logExceptionAsError(new RuntimeException("Could not find the primary nic configuration"));
    }

    private static void associateBackEndsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIpConfiguration ipConfig, String ... backendNames) {
        if (ipConfig == null || ipConfig.loadBalancerBackendAddressPools() == null) {
            return;
        }
        ArrayList<SubResource> backendSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            backendSubResourcesToAssociate.add(new SubResource().withId(backendPoolId));
        }
        for (SubResource backendSubResource : backendSubResourcesToAssociate) {
            ipConfig.loadBalancerBackendAddressPools().add(backendSubResource);
        }
    }

    private static void associateInboundNATPoolsToIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIpConfiguration ipConfig, String ... inboundNatPools) {
        ArrayList<SubResource> inboundNatPoolSubResourcesToAssociate = new ArrayList<SubResource>();
        for (String inboundNatPool : inboundNatPools) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", inboundNatPool);
            boolean found = false;
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            inboundNatPoolSubResourcesToAssociate.add(new SubResource().withId(inboundNatPoolId));
        }
        for (SubResource backendSubResource : inboundNatPoolSubResourcesToAssociate) {
            ipConfig.loadBalancerInboundNatPools().add(backendSubResource);
        }
    }

    private static Map<String, LoadBalancerBackend> getBackendsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        if (ipConfig == null || ipConfig.loadBalancerBackendAddressPools() == null) {
            return Collections.emptyMap();
        }
        String loadBalancerId = loadBalancer.id();
        HashMap<String, LoadBalancerBackend> attachedBackends = new HashMap<String, LoadBalancerBackend>();
        Map lbBackends = loadBalancer.backends();
        for (LoadBalancerBackend lbBackend : lbBackends.values()) {
            String backendId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", lbBackend.name());
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendId)) continue;
                attachedBackends.put(lbBackend.name(), lbBackend);
            }
        }
        return attachedBackends;
    }

    private static Map<String, LoadBalancerInboundNatPool> getInboundNatPoolsAssociatedWithIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        if (ipConfig == null || ipConfig.loadBalancerInboundNatPools() == null) {
            return Collections.emptyMap();
        }
        String loadBalancerId = loadBalancer.id();
        HashMap<String, LoadBalancerInboundNatPool> attachedInboundNatPools = new HashMap<String, LoadBalancerInboundNatPool>();
        Map lbInboundNatPools = loadBalancer.inboundNatPools();
        for (LoadBalancerInboundNatPool lbInboundNatPool : lbInboundNatPools.values()) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", lbInboundNatPool.name());
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                attachedInboundNatPools.put(lbInboundNatPool.name(), lbInboundNatPool);
            }
        }
        return attachedInboundNatPools;
    }

    private static void associateLoadBalancerToIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        Collection backends = loadBalancer.backends().values();
        String[] backendNames = new String[backends.size()];
        int i = 0;
        for (LoadBalancerBackend backend : backends) {
            backendNames[i] = backend.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateBackEndsToIpConfiguration(loadBalancer.id(), ipConfig, backendNames);
        Collection inboundNatPools = loadBalancer.inboundNatPools().values();
        String[] natPoolNames = new String[inboundNatPools.size()];
        i = 0;
        for (LoadBalancerInboundNatPool inboundNatPool : inboundNatPools) {
            natPoolNames[i] = inboundNatPool.name();
            ++i;
        }
        VirtualMachineScaleSetImpl.associateInboundNATPoolsToIpConfiguration(loadBalancer.id(), ipConfig, natPoolNames);
    }

    private static void removeLoadBalancerAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        VirtualMachineScaleSetImpl.removeAllBackendAssociationFromIpConfiguration(loadBalancer, ipConfig);
        VirtualMachineScaleSetImpl.removeAllInboundNatPoolAssociationFromIpConfiguration(loadBalancer, ipConfig);
    }

    private static void removeAllBackendAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        if (ipConfig == null || ipConfig.loadBalancerBackendAddressPools() == null) {
            return;
        }
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
            if (!subResource.id().toLowerCase(Locale.ROOT).startsWith(loadBalancer.id().toLowerCase(Locale.ROOT) + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeAllInboundNatPoolAssociationFromIpConfiguration(LoadBalancer loadBalancer, VirtualMachineScaleSetIpConfiguration ipConfig) {
        if (ipConfig == null || ipConfig.loadBalancerInboundNatPools() == null) {
            return;
        }
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
            if (!subResource.id().toLowerCase(Locale.ROOT).startsWith(loadBalancer.id().toLowerCase(Locale.ROOT) + "/")) continue;
            toRemove.add(subResource);
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static void removeBackendsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIpConfiguration ipConfig, String ... backendNames) {
        if (ipConfig == null || ipConfig.loadBalancerBackendAddressPools() == null) {
            return;
        }
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String backendName : backendNames) {
            String backendPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "backendAddressPools", backendName);
            for (SubResource subResource : ipConfig.loadBalancerBackendAddressPools()) {
                if (!subResource.id().equalsIgnoreCase(backendPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerBackendAddressPools().remove(subResource);
        }
    }

    private static void removeInboundNatPoolsFromIpConfiguration(String loadBalancerId, VirtualMachineScaleSetIpConfiguration ipConfig, String ... inboundNatPoolNames) {
        if (ipConfig == null || ipConfig.loadBalancerInboundNatPools() == null) {
            return;
        }
        ArrayList<SubResource> toRemove = new ArrayList<SubResource>();
        block0: for (String natPoolName : inboundNatPoolNames) {
            String inboundNatPoolId = VirtualMachineScaleSetImpl.mergePath(loadBalancerId, "inboundNatPools", natPoolName);
            for (SubResource subResource : ipConfig.loadBalancerInboundNatPools()) {
                if (!subResource.id().equalsIgnoreCase(inboundNatPoolId)) continue;
                toRemove.add(subResource);
                continue block0;
            }
        }
        for (SubResource subResource : toRemove) {
            ipConfig.loadBalancerInboundNatPools().remove(subResource);
        }
    }

    private static <T> void addToList(List<T> list, T[] items) {
        list.addAll(Arrays.asList(items));
    }

    private static String mergePath(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            while (segment.length() > 1 && segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.length() <= 0) continue;
            builder.append(segment);
            builder.append("/");
        }
        String merged = builder.toString();
        if (merged.endsWith("/")) {
            merged = merged.substring(0, merged.length() - 1);
        }
        return merged;
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (VirtualMachineScaleSetImpl.this.innerModel() != null && ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.innerModel())).identity() != null) {
                    return ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.innerModel())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (VirtualMachineScaleSetImpl.this.innerModel() != null) {
                    return ((VirtualMachineScaleSetInner)((Object)VirtualMachineScaleSetImpl.this.innerModel())).id();
                }
                return null;
            }
        };
    }

    protected VirtualMachineScaleSetImpl withUnmanagedDataDisk(VirtualMachineScaleSetUnmanagedDataDiskImpl unmanagedDisk) {
        this.initVMProfileIfNecessary();
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().dataDisks() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().withDataDisks(new ArrayList<VirtualMachineScaleSetDataDisk>());
        }
        List<VirtualMachineScaleSetDataDisk> dataDisks = ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().dataDisks();
        dataDisks.add((VirtualMachineScaleSetDataDisk)unmanagedDisk.innerModel());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((VirtualMachineScaleSetInner)((Object)this.innerModel())).zones() == null) {
            ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        return this;
    }

    private boolean isOSDiskFromImage(VirtualMachineScaleSetOSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.FROM_IMAGE;
    }

    private boolean isOsDiskFromCustomImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.id() != null;
    }

    private boolean isOSDiskFromPlatformImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.publisher() != null && imageReference.offer() != null && imageReference.sku() != null && imageReference.version() != null;
    }

    private boolean isOSDiskFromStoredImage(VirtualMachineScaleSetStorageProfile storageProfile) {
        VirtualMachineScaleSetOSDisk osDisk = storageProfile.osDisk();
        return this.isOSDiskFromImage(osDisk) && osDisk.image() != null && osDisk.image().uri() != null;
    }

    private void throwIfManagedDiskDisabled(String message) {
        if (!this.isManagedDiskEnabled()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(message));
        }
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnosticsOnManagedStorageAccount() {
        this.bootDiagnosticsHandler.withBootDiagnostics(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics() {
        this.bootDiagnosticsHandler.withBootDiagnostics(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(Creatable<StorageAccount> creatable) {
        this.bootDiagnosticsHandler.withBootDiagnostics(creatable);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(StorageAccount storageAccount) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withBootDiagnostics(String storageAccountBlobEndpointUri) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccountBlobEndpointUri);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutBootDiagnostics() {
        this.bootDiagnosticsHandler.withoutBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withMaxPrice(Double maxPrice) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withBillingProfile(new BillingProfile().withMaxPrice(maxPrice));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePriority(VirtualMachinePriorityTypes priority) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withPriority(priority);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withLowPriorityVirtualMachine() {
        this.withVirtualMachinePriority(VirtualMachinePriorityTypes.LOW);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withLowPriorityVirtualMachine(VirtualMachineEvictionPolicyTypes policy) {
        this.withLowPriorityVirtualMachine();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSpotPriorityVirtualMachine() {
        this.withVirtualMachinePriority(VirtualMachinePriorityTypes.SPOT);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSpotPriorityVirtualMachine(VirtualMachineEvictionPolicyTypes policy) {
        this.withSpotPriorityVirtualMachine();
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp() {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig.publicIpAddressConfiguration() != null) {
            return this;
        }
        VirtualMachineScaleSetPublicIpAddressConfiguration pipConfig = new VirtualMachineScaleSetPublicIpAddressConfiguration();
        pipConfig.withName("pip1");
        pipConfig.withIdleTimeoutInMinutes(15);
        nicIpConfig.withPublicIpAddressConfiguration(pipConfig);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp(String leafDomainLabel) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig.publicIpAddressConfiguration() != null) {
            if (nicIpConfig.publicIpAddressConfiguration().dnsSettings() != null) {
                nicIpConfig.publicIpAddressConfiguration().dnsSettings().withDomainNameLabel(leafDomainLabel);
            } else {
                nicIpConfig.publicIpAddressConfiguration().withDnsSettings(new VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings());
                nicIpConfig.publicIpAddressConfiguration().dnsSettings().withDomainNameLabel(leafDomainLabel);
            }
        } else {
            VirtualMachineScaleSetPublicIpAddressConfiguration pipConfig = new VirtualMachineScaleSetPublicIpAddressConfiguration();
            pipConfig.withName("pip1");
            pipConfig.withIdleTimeoutInMinutes(15);
            pipConfig.withDnsSettings(new VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings());
            pipConfig.dnsSettings().withDomainNameLabel(leafDomainLabel);
            nicIpConfig.withPublicIpAddressConfiguration(pipConfig);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withVirtualMachinePublicIp(VirtualMachineScaleSetPublicIpAddressConfiguration pipConfig) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        nicIpConfig.withPublicIpAddressConfiguration(pipConfig);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAcceleratedNetworking() {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableAcceleratedNetworking(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutAcceleratedNetworking() {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableAcceleratedNetworking(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withIpForwarding() {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withEnableIpForwarding(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutIpForwarding() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig == null) {
            return this;
        }
        nicConfig.withEnableIpForwarding(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withNetworkSecurityGroup(new SubResource().withId(networkSecurityGroup.id()));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingNetworkSecurityGroupId(String networkSecurityGroupId) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        nicConfig.withNetworkSecurityGroup(new SubResource().withId(networkSecurityGroupId));
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutNetworkSecurityGroup() {
        VirtualMachineScaleSetNetworkConfiguration nicConfig = this.primaryNicConfiguration();
        if (nicConfig == null) {
            return this;
        }
        nicConfig.withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withSinglePlacementGroup() {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withSinglePlacementGroup(true);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutSinglePlacementGroup() {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withSinglePlacementGroup(false);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationGatewayBackendPool(String backendPoolId) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig.applicationGatewayBackendAddressPools() == null) {
            nicIpConfig.withApplicationGatewayBackendAddressPools(new ArrayList<SubResource>());
        }
        boolean found = false;
        for (SubResource backendPool : nicIpConfig.applicationGatewayBackendAddressPools()) {
            if (!backendPool.id().equalsIgnoreCase(backendPoolId)) continue;
            found = true;
            break;
        }
        if (!found) {
            nicIpConfig.applicationGatewayBackendAddressPools().add(new SubResource().withId(backendPoolId));
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutApplicationGatewayBackendPool(String backendPoolId) {
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig == null || nicIpConfig.applicationGatewayBackendAddressPools() == null) {
            return this;
        }
        int foundIndex = -1;
        int index = -1;
        for (SubResource backendPool : nicIpConfig.applicationGatewayBackendAddressPools()) {
            ++index;
            if (!backendPool.id().equalsIgnoreCase(backendPoolId)) continue;
            foundIndex = index;
            break;
        }
        if (foundIndex != -1) {
            nicIpConfig.applicationGatewayBackendAddressPools().remove(foundIndex);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationSecurityGroup(ApplicationSecurityGroup applicationSecurityGroup) {
        return this.withExistingApplicationSecurityGroupId(applicationSecurityGroup.id());
    }

    @Override
    public VirtualMachineScaleSetImpl withExistingApplicationSecurityGroupId(String applicationSecurityGroupId) {
        this.initVMProfileIfNecessary();
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig.applicationSecurityGroups() == null) {
            nicIpConfig.withApplicationSecurityGroups(new ArrayList<SubResource>());
        }
        boolean found = false;
        for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
            if (!asg.id().equalsIgnoreCase(applicationSecurityGroupId)) continue;
            found = true;
            break;
        }
        if (!found) {
            nicIpConfig.applicationSecurityGroups().add(new SubResource().withId(applicationSecurityGroupId));
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withoutApplicationSecurityGroup(String applicationSecurityGroupId) {
        VirtualMachineScaleSetIpConfiguration nicIpConfig = this.primaryNicDefaultIpConfiguration();
        if (nicIpConfig == null || nicIpConfig.applicationSecurityGroups() == null) {
            return this;
        }
        int foundIndex = -1;
        int index = -1;
        for (SubResource asg : nicIpConfig.applicationSecurityGroups()) {
            ++index;
            if (!asg.id().equalsIgnoreCase(applicationSecurityGroupId)) continue;
            foundIndex = index;
            break;
        }
        if (foundIndex != -1) {
            nicIpConfig.applicationSecurityGroups().remove(foundIndex);
        }
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withDoNotRunExtensionsOnOverprovisionedVMs(doNotRunExtensionsOnOverprovisionedVMs);
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    private Mono<VirtualMachineScaleSetImpl> createNewProximityPlacementGroupAsync() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((VirtualMachineScaleSetInner)((Object)this.innerModel())).location());
            return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().createOrUpdateAsync(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner).map(ppgInner -> {
                ((VirtualMachineScaleSetInner)((Object)((Object)this.innerModel()))).withProximityPlacementGroup(new SubResource().withId(ppgInner.id()));
                return this;
            });
        }
        return Mono.just((Object)this);
    }

    @Override
    public VirtualMachineScaleSetImpl withPlan(PurchasePlan plan) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).withPlan(new Plan());
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).plan().withPublisher(plan.publisher()).withProduct(plan.product()).withName(plan.name());
        return this;
    }

    @Override
    public VirtualMachineScaleSetImpl withPlacement(DiffDiskPlacement placement) {
        ((VirtualMachineScaleSetInner)((Object)this.innerModel())).virtualMachineProfile().storageProfile().osDisk().diffDiskSettings().withPlacement(placement);
        return this;
    }

    private class ManagedDataDiskCollection {
        private final List<VirtualMachineScaleSetDataDisk> implicitDisksToAssociate = new ArrayList<VirtualMachineScaleSetDataDisk>();
        private final List<Integer> diskLunsToRemove = new ArrayList<Integer>();
        private final List<VirtualMachineScaleSetDataDisk> newDisksFromImage = new ArrayList<VirtualMachineScaleSetDataDisk>();
        private final VirtualMachineScaleSetImpl vmss;
        private CachingTypes defaultCachingType;
        private StorageAccountTypes defaultStorageAccountType;

        ManagedDataDiskCollection(VirtualMachineScaleSetImpl vmss) {
            this.vmss = vmss;
        }

        void setDefaultCachingType(CachingTypes cachingType) {
            this.defaultCachingType = cachingType;
        }

        void setDefaultStorageAccountType(StorageAccountTypes defaultStorageAccountType) {
            this.defaultStorageAccountType = defaultStorageAccountType;
        }

        void setDataDisksDefaults() {
            if (this.vmss.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile() == null) {
                return;
            }
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile().storageProfile();
            if (this.isPending()) {
                if (storageProfile.dataDisks() == null) {
                    storageProfile.withDataDisks(new ArrayList<VirtualMachineScaleSetDataDisk>());
                }
                List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
                ArrayList<Integer> usedLuns = new ArrayList<Integer>();
                for (VirtualMachineScaleSetDataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (VirtualMachineScaleSetDataDisk dataDisk : this.implicitDisksToAssociate) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (VirtualMachineScaleSetDataDisk dataDisk : this.newDisksFromImage) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                Callable<Integer> nextLun = () -> {
                    Integer lun = 0;
                    while (usedLuns.contains(lun)) {
                        Integer $1746166907 = lun;
                        lun = lun + 1;
                    }
                    usedLuns.add(lun);
                    return lun;
                };
                try {
                    this.setImplicitDataDisks(nextLun);
                }
                catch (Exception ex) {
                    throw VirtualMachineScaleSetImpl.this.logger.logExceptionAsError(Exceptions.propagate((Throwable)ex));
                }
                this.setImageBasedDataDisks();
                this.removeDataDisks();
            }
            if (storageProfile.dataDisks() != null && storageProfile.dataDisks().size() == 0 && this.vmss.isInCreateMode()) {
                storageProfile.withDataDisks(null);
            }
            this.clear();
        }

        private void clear() {
            this.implicitDisksToAssociate.clear();
            this.diskLunsToRemove.clear();
            this.newDisksFromImage.clear();
        }

        private boolean isPending() {
            return this.implicitDisksToAssociate.size() > 0 || this.diskLunsToRemove.size() > 0 || this.newDisksFromImage.size() > 0;
        }

        private void setImplicitDataDisks(Callable<Integer> nextLun) throws Exception {
            if (this.vmss.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile() == null) {
                return;
            }
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            for (VirtualMachineScaleSetDataDisk dataDisk : this.implicitDisksToAssociate) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.EMPTY);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun(nextLun.call());
                }
                if (dataDisk.managedDisk() == null) {
                    dataDisk.withManagedDisk(new VirtualMachineScaleSetManagedDiskParameters());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.managedDisk().storageAccountType() == null) {
                    dataDisk.managedDisk().withStorageAccountType(this.getDefaultStorageAccountType());
                }
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImageBasedDataDisks() {
            if (this.vmss.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile() == null) {
                return;
            }
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            for (VirtualMachineScaleSetDataDisk dataDisk : this.newDisksFromImage) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void removeDataDisks() {
            if (this.vmss.innerModel() == null || ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile() == null) {
                return;
            }
            VirtualMachineScaleSetStorageProfile storageProfile = ((VirtualMachineScaleSetInner)((Object)this.vmss.innerModel())).virtualMachineProfile().storageProfile();
            List<VirtualMachineScaleSetDataDisk> dataDisks = storageProfile.dataDisks();
            block0: for (Integer lun : this.diskLunsToRemove) {
                int indexToRemove = 0;
                for (VirtualMachineScaleSetDataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == lun.intValue()) {
                        dataDisks.remove(indexToRemove);
                        continue block0;
                    }
                    ++indexToRemove;
                }
            }
        }

        private CachingTypes getDefaultCachingType() {
            if (this.defaultCachingType == null) {
                return CachingTypes.READ_WRITE;
            }
            return this.defaultCachingType;
        }

        private StorageAccountTypes getDefaultStorageAccountType() {
            if (this.defaultStorageAccountType == null) {
                return StorageAccountTypes.STANDARD_LRS;
            }
            return this.defaultStorageAccountType;
        }
    }

    private class BootDiagnosticsHandler {
        private final VirtualMachineScaleSetImpl vmssImpl;
        private String creatableDiagnosticsStorageAccountKey;
        private String creatableStorageAccountKey;
        private StorageAccount existingStorageAccountToAssociate;
        private boolean useManagedStorageAccount = false;

        BootDiagnosticsHandler(VirtualMachineScaleSetImpl vmssImpl) {
            this.vmssImpl = vmssImpl;
            if (this.isBootDiagnosticsEnabled() && this.vmssInner() != null && this.vmssInner().virtualMachineProfile() != null && this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().storageUri() == null) {
                this.useManagedStorageAccount = true;
            }
        }

        public boolean isBootDiagnosticsEnabled() {
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return false;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile != null && diagnosticsProfile.bootDiagnostics() != null && diagnosticsProfile.bootDiagnostics().enabled() != null) {
                return diagnosticsProfile.bootDiagnostics().enabled();
            }
            return false;
        }

        public String bootDiagnosticsStorageUri() {
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return null;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile != null && diagnosticsProfile.bootDiagnostics() != null) {
                return diagnosticsProfile.bootDiagnostics().storageUri();
            }
            return null;
        }

        BootDiagnosticsHandler withBootDiagnostics(boolean useManagedStorageAccount) {
            this.enableDisable(true);
            this.useManagedStorageAccount = useManagedStorageAccount;
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(Creatable<StorageAccount> creatable) {
            this.enableDisable(true);
            this.useManagedStorageAccount = false;
            this.creatableDiagnosticsStorageAccountKey = this.vmssImpl.addDependency(creatable);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(String storageAccountBlobEndpointUri) {
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return this;
            }
            this.enableDisable(true);
            this.useManagedStorageAccount = false;
            this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccountBlobEndpointUri);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(StorageAccount storageAccount) {
            return this.withBootDiagnostics(storageAccount.endPoints().primary().blob());
        }

        BootDiagnosticsHandler withoutBootDiagnostics() {
            this.enableDisable(false);
            this.useManagedStorageAccount = false;
            return this;
        }

        void prepare() {
            if (this.useManagedStorageAccount) {
                return;
            }
            this.creatableStorageAccountKey = null;
            this.existingStorageAccountToAssociate = null;
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = ResourceManagerUtils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                return;
            }
            if (!this.vmssImpl.creatableStorageAccountKeys.isEmpty()) {
                this.creatableStorageAccountKey = (String)this.vmssImpl.creatableStorageAccountKeys.get(0);
                return;
            }
            if (!this.vmssImpl.existingStorageAccountsToAssociate.isEmpty()) {
                this.existingStorageAccountToAssociate = (StorageAccount)this.vmssImpl.existingStorageAccountsToAssociate.get(0);
                return;
            }
            String accountName = this.vmssImpl.namer.getRandomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.vmssImpl.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmssImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmssImpl.regionName())).withNewResourceGroup(this.vmssImpl.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmssImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmssImpl.regionName())).withExistingResourceGroup(this.vmssImpl.resourceGroupName());
            this.creatableDiagnosticsStorageAccountKey = this.vmssImpl.addDependency(storageAccountCreatable);
        }

        void handleDiagnosticsSettings() {
            if (this.useManagedStorageAccount) {
                return;
            }
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmssInner().virtualMachineProfile().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = ResourceManagerUtils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            StorageAccount storageAccount = null;
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmssImpl.taskResult(this.creatableDiagnosticsStorageAccountKey);
            } else if (this.creatableStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmssImpl.taskResult(this.creatableStorageAccountKey);
            } else if (this.existingStorageAccountToAssociate != null) {
                storageAccount = this.existingStorageAccountToAssociate;
            }
            if (storageAccount == null) {
                throw VirtualMachineScaleSetImpl.this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Unable to retrieve expected storageAccount instance for BootDiagnostics"));
            }
            this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccount.endPoints().primary().blob());
        }

        private VirtualMachineScaleSetInner vmssInner() {
            return (VirtualMachineScaleSetInner)((Object)this.vmssImpl.innerModel());
        }

        private void enableDisable(boolean enable) {
            if (this.vmssInner() == null || this.vmssInner().virtualMachineProfile() == null) {
                return;
            }
            if (this.vmssInner().virtualMachineProfile().diagnosticsProfile() == null) {
                this.vmssInner().virtualMachineProfile().withDiagnosticsProfile(new DiagnosticsProfile());
            }
            if (this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics() == null) {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().withBootDiagnostics(new BootDiagnostics());
            }
            if (enable) {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withEnabled(true);
            } else {
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withEnabled(false);
                this.vmssInner().virtualMachineProfile().diagnosticsProfile().bootDiagnostics().withStorageUri(null);
            }
        }
    }
}

