/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.models.Sku;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class VirtualMachineScaleSetSkuTypes {
    private static final Map<String, VirtualMachineScaleSetSkuTypes> VALUES_BY_NAME = new HashMap<String, VirtualMachineScaleSetSkuTypes>();
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A0 = new VirtualMachineScaleSetSkuTypes("Standard_A0", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A1 = new VirtualMachineScaleSetSkuTypes("Standard_A1", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A2 = new VirtualMachineScaleSetSkuTypes("Standard_A2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A3 = new VirtualMachineScaleSetSkuTypes("Standard_A3", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A4 = new VirtualMachineScaleSetSkuTypes("Standard_A4", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A5 = new VirtualMachineScaleSetSkuTypes("Standard_A5", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A6 = new VirtualMachineScaleSetSkuTypes("Standard_A6", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A7 = new VirtualMachineScaleSetSkuTypes("Standard_A7", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A8 = new VirtualMachineScaleSetSkuTypes("Standard_A8", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A9 = new VirtualMachineScaleSetSkuTypes("Standard_A9", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A10 = new VirtualMachineScaleSetSkuTypes("Standard_A10", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A11 = new VirtualMachineScaleSetSkuTypes("Standard_A11", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D1 = new VirtualMachineScaleSetSkuTypes("Standard_D1", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D2 = new VirtualMachineScaleSetSkuTypes("Standard_D2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D3 = new VirtualMachineScaleSetSkuTypes("Standard_D3", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D4 = new VirtualMachineScaleSetSkuTypes("Standard_D4", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D11 = new VirtualMachineScaleSetSkuTypes("Standard_D11", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D12 = new VirtualMachineScaleSetSkuTypes("Standard_D12", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D13 = new VirtualMachineScaleSetSkuTypes("Standard_D13", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D14 = new VirtualMachineScaleSetSkuTypes("Standard_D14", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_A1_V2 = new VirtualMachineScaleSetSkuTypes("Standard_A1_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D1_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D1_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D2_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D2_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D3_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D3_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D4_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D4_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D5_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D5_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D11_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D11_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D12_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D12_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D13_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D13_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D14_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D14_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_D15_V2 = new VirtualMachineScaleSetSkuTypes("Standard_D15_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS1 = new VirtualMachineScaleSetSkuTypes("Standard_DS1", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS2 = new VirtualMachineScaleSetSkuTypes("Standard_DS2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS3 = new VirtualMachineScaleSetSkuTypes("Standard_DS3", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS4 = new VirtualMachineScaleSetSkuTypes("Standard_DS4", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS11 = new VirtualMachineScaleSetSkuTypes("Standard_DS11", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS12 = new VirtualMachineScaleSetSkuTypes("Standard_DS12", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS13 = new VirtualMachineScaleSetSkuTypes("Standard_DS13", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS14 = new VirtualMachineScaleSetSkuTypes("Standard_DS14", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS1_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS1_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS2_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS2_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS3_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS3_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS4_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS4_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS5_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS5_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS11_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS11_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS12_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS12_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS13_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS13_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS14_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS14_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_DS15_V2 = new VirtualMachineScaleSetSkuTypes("Standard_DS15_v2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F1S = new VirtualMachineScaleSetSkuTypes("STANDARD_F1S", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F2S = new VirtualMachineScaleSetSkuTypes("STANDARD_F2S", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F4S = new VirtualMachineScaleSetSkuTypes("STANDARD_F4S", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F8S = new VirtualMachineScaleSetSkuTypes("STANDARD_F8S", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F16S = new VirtualMachineScaleSetSkuTypes("STANDARD_F16S", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F1 = new VirtualMachineScaleSetSkuTypes("STANDARD_F1", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F2 = new VirtualMachineScaleSetSkuTypes("STANDARD_F2", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F4 = new VirtualMachineScaleSetSkuTypes("STANDARD_F4", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F8 = new VirtualMachineScaleSetSkuTypes("STANDARD_F8", "Standard");
    public static final VirtualMachineScaleSetSkuTypes STANDARD_F16 = new VirtualMachineScaleSetSkuTypes("STANDARD_F16", "Standard");
    private final Sku sku;
    private final String value;

    public static VirtualMachineScaleSetSkuTypes[] values() {
        Collection<VirtualMachineScaleSetSkuTypes> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new VirtualMachineScaleSetSkuTypes[valuesCollection.size()]);
    }

    public VirtualMachineScaleSetSkuTypes(String skuName, String skuTier) {
        this(new Sku().withName(skuName).withTier(skuTier));
    }

    public VirtualMachineScaleSetSkuTypes(Sku sku) {
        this.sku = VirtualMachineScaleSetSkuTypes.createCopy(sku);
        this.value = this.sku.tier() == null ? this.sku.name() : this.sku.name() + '_' + this.sku.tier();
        VALUES_BY_NAME.put(this.value.toLowerCase(Locale.ROOT), this);
    }

    public static VirtualMachineScaleSetSkuTypes fromSku(Sku sku) {
        VirtualMachineScaleSetSkuTypes result;
        if (sku == null) {
            return null;
        }
        String nameToLookFor = sku.name();
        if (sku.tier() != null) {
            nameToLookFor = nameToLookFor + '_' + sku.tier();
        }
        if ((result = VALUES_BY_NAME.get(nameToLookFor.toLowerCase(Locale.ROOT))) != null) {
            return result;
        }
        return new VirtualMachineScaleSetSkuTypes(sku);
    }

    public static VirtualMachineScaleSetSkuTypes fromSkuNameAndTier(String skuName, String skuTier) {
        return VirtualMachineScaleSetSkuTypes.fromSku(new Sku().withName(skuName).withTier(skuTier));
    }

    public Sku sku() {
        return VirtualMachineScaleSetSkuTypes.createCopy(this.sku);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VirtualMachineScaleSetSkuTypes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.value == null) {
            return ((VirtualMachineScaleSetSkuTypes)obj).value == null;
        }
        return this.value.equalsIgnoreCase(((VirtualMachineScaleSetSkuTypes)obj).value);
    }

    private static Sku createCopy(Sku sku) {
        return new Sku().withName(sku.name()).withTier(sku.tier()).withCapacity(sku.capacity());
    }
}

