/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RunCommandManagedIdentity;
import com.azure.resourcemanager.compute.models.ScriptShellTypes;
import java.io.IOException;

public final class VirtualMachineRunCommandScriptSource
implements JsonSerializable<VirtualMachineRunCommandScriptSource> {
    private String script;
    private String scriptUri;
    private String commandId;
    private RunCommandManagedIdentity scriptUriManagedIdentity;
    private ScriptShellTypes scriptShell;
    private String galleryScriptReferenceId;

    public String script() {
        return this.script;
    }

    public VirtualMachineRunCommandScriptSource withScript(String script) {
        this.script = script;
        return this;
    }

    public String scriptUri() {
        return this.scriptUri;
    }

    public VirtualMachineRunCommandScriptSource withScriptUri(String scriptUri) {
        this.scriptUri = scriptUri;
        return this;
    }

    public String commandId() {
        return this.commandId;
    }

    public VirtualMachineRunCommandScriptSource withCommandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    public RunCommandManagedIdentity scriptUriManagedIdentity() {
        return this.scriptUriManagedIdentity;
    }

    public VirtualMachineRunCommandScriptSource withScriptUriManagedIdentity(RunCommandManagedIdentity scriptUriManagedIdentity) {
        this.scriptUriManagedIdentity = scriptUriManagedIdentity;
        return this;
    }

    public ScriptShellTypes scriptShell() {
        return this.scriptShell;
    }

    public VirtualMachineRunCommandScriptSource withScriptShell(ScriptShellTypes scriptShell) {
        this.scriptShell = scriptShell;
        return this;
    }

    public String galleryScriptReferenceId() {
        return this.galleryScriptReferenceId;
    }

    public VirtualMachineRunCommandScriptSource withGalleryScriptReferenceId(String galleryScriptReferenceId) {
        this.galleryScriptReferenceId = galleryScriptReferenceId;
        return this;
    }

    public void validate() {
        if (this.scriptUriManagedIdentity() != null) {
            this.scriptUriManagedIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeStringField("scriptUri", this.scriptUri);
        jsonWriter.writeStringField("commandId", this.commandId);
        jsonWriter.writeJsonField("scriptUriManagedIdentity", (JsonSerializable)this.scriptUriManagedIdentity);
        jsonWriter.writeStringField("scriptShell", this.scriptShell == null ? null : this.scriptShell.toString());
        jsonWriter.writeStringField("galleryScriptReferenceId", this.galleryScriptReferenceId);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineRunCommandScriptSource fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineRunCommandScriptSource)jsonReader.readObject(reader -> {
            VirtualMachineRunCommandScriptSource deserializedVirtualMachineRunCommandScriptSource = new VirtualMachineRunCommandScriptSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("script".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.script = reader.getString();
                    continue;
                }
                if ("scriptUri".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.scriptUri = reader.getString();
                    continue;
                }
                if ("commandId".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.commandId = reader.getString();
                    continue;
                }
                if ("scriptUriManagedIdentity".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.scriptUriManagedIdentity = RunCommandManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("scriptShell".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.scriptShell = ScriptShellTypes.fromString(reader.getString());
                    continue;
                }
                if ("galleryScriptReferenceId".equals(fieldName)) {
                    deserializedVirtualMachineRunCommandScriptSource.galleryScriptReferenceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineRunCommandScriptSource;
        });
    }
}

