/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.NetworkInterfaceReferenceProperties;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import java.io.IOException;

public final class NetworkInterfaceReference
extends SubResource {
    private NetworkInterfaceReferenceProperties innerProperties;

    private NetworkInterfaceReferenceProperties innerProperties() {
        return this.innerProperties;
    }

    public NetworkInterfaceReference withId(String id) {
        super.withId(id);
        return this;
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public NetworkInterfaceReference withPrimary(Boolean primary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfaceReferenceProperties();
        }
        this.innerProperties().withPrimary(primary);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public NetworkInterfaceReference withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkInterfaceReferenceProperties();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceReference fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceReference)((Object)jsonReader.readObject(reader -> {
            NetworkInterfaceReference deserializedNetworkInterfaceReference = new NetworkInterfaceReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkInterfaceReference.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkInterfaceReference.innerProperties = NetworkInterfaceReferenceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceReference;
        }));
    }
}

