/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RestorePointInner;
import com.azure.resourcemanager.compute.models.RestorePointCollectionSourceProperties;
import java.io.IOException;
import java.util.List;

public final class RestorePointCollectionProperties
implements JsonSerializable<RestorePointCollectionProperties> {
    private RestorePointCollectionSourceProperties source;
    private String provisioningState;
    private String restorePointCollectionId;
    private List<RestorePointInner> restorePoints;
    private Boolean instantAccess;

    public RestorePointCollectionSourceProperties source() {
        return this.source;
    }

    public RestorePointCollectionProperties withSource(RestorePointCollectionSourceProperties source) {
        this.source = source;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String restorePointCollectionId() {
        return this.restorePointCollectionId;
    }

    public List<RestorePointInner> restorePoints() {
        return this.restorePoints;
    }

    public Boolean instantAccess() {
        return this.instantAccess;
    }

    public RestorePointCollectionProperties withInstantAccess(Boolean instantAccess) {
        this.instantAccess = instantAccess;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.restorePoints() != null) {
            this.restorePoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeBooleanField("instantAccess", this.instantAccess);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointCollectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointCollectionProperties)jsonReader.readObject(reader -> {
            RestorePointCollectionProperties deserializedRestorePointCollectionProperties = new RestorePointCollectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedRestorePointCollectionProperties.source = RestorePointCollectionSourceProperties.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRestorePointCollectionProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("restorePointCollectionId".equals(fieldName)) {
                    deserializedRestorePointCollectionProperties.restorePointCollectionId = reader.getString();
                    continue;
                }
                if ("restorePoints".equals(fieldName)) {
                    List restorePoints;
                    deserializedRestorePointCollectionProperties.restorePoints = restorePoints = reader.readArray(reader1 -> RestorePointInner.fromJson(reader1));
                    continue;
                }
                if ("instantAccess".equals(fieldName)) {
                    deserializedRestorePointCollectionProperties.instantAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointCollectionProperties;
        });
    }
}

