/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetManagedDiskParameters;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetUpdateOSDisk
implements JsonSerializable<VirtualMachineScaleSetUpdateOSDisk> {
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiffDiskSettings diffDiskSettings;
    private Integer diskSizeGB;
    private VirtualHardDisk image;
    private List<String> vhdContainers;
    private VirtualMachineScaleSetManagedDiskParameters managedDisk;
    private DiskDeleteOptionTypes deleteOption;

    public CachingTypes caching() {
        return this.caching;
    }

    public VirtualMachineScaleSetUpdateOSDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public VirtualMachineScaleSetUpdateOSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiffDiskSettings diffDiskSettings() {
        return this.diffDiskSettings;
    }

    public VirtualMachineScaleSetUpdateOSDisk withDiffDiskSettings(DiffDiskSettings diffDiskSettings) {
        this.diffDiskSettings = diffDiskSettings;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualMachineScaleSetUpdateOSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public VirtualMachineScaleSetUpdateOSDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public List<String> vhdContainers() {
        return this.vhdContainers;
    }

    public VirtualMachineScaleSetUpdateOSDisk withVhdContainers(List<String> vhdContainers) {
        this.vhdContainers = vhdContainers;
        return this;
    }

    public VirtualMachineScaleSetManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public VirtualMachineScaleSetUpdateOSDisk withManagedDisk(VirtualMachineScaleSetManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetUpdateOSDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.diffDiskSettings() != null) {
            this.diffDiskSettings().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeJsonField("diffDiskSettings", (JsonSerializable)this.diffDiskSettings);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("image", (JsonSerializable)this.image);
        jsonWriter.writeArrayField("vhdContainers", this.vhdContainers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdateOSDisk fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdateOSDisk)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateOSDisk deserializedVirtualMachineScaleSetUpdateOSDisk = new VirtualMachineScaleSetUpdateOSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("caching".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diffDiskSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.diffDiskSettings = DiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.image = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("vhdContainers".equals(fieldName)) {
                    List vhdContainers;
                    deserializedVirtualMachineScaleSetUpdateOSDisk.vhdContainers = vhdContainers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.managedDisk = VirtualMachineScaleSetManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateOSDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdateOSDisk;
        });
    }
}

