/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineNetworkInterfaceConfigurationProperties;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceIpConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineNetworkInterfaceConfiguration
implements JsonSerializable<VirtualMachineNetworkInterfaceConfiguration> {
    private String name;
    private VirtualMachineNetworkInterfaceConfigurationProperties innerProperties;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineNetworkInterfaceConfiguration.class);

    public String name() {
        return this.name;
    }

    public VirtualMachineNetworkInterfaceConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    private VirtualMachineNetworkInterfaceConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VirtualMachineNetworkInterfaceConfiguration withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public VirtualMachineNetworkInterfaceConfiguration withPrimary(Boolean primary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withPrimary(primary);
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteOption();
    }

    public VirtualMachineNetworkInterfaceConfiguration withDeleteOption(DeleteOptions deleteOption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withDeleteOption(deleteOption);
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAcceleratedNetworking();
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withEnableAcceleratedNetworking(enableAcceleratedNetworking);
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.innerProperties() == null ? null : this.innerProperties().disableTcpStateTracking();
    }

    public VirtualMachineNetworkInterfaceConfiguration withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withDisableTcpStateTracking(disableTcpStateTracking);
        return this;
    }

    public Boolean enableFpga() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFpga();
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableFpga(Boolean enableFpga) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withEnableFpga(enableFpga);
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.innerProperties() == null ? null : this.innerProperties().enableIpForwarding();
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableIpForwarding(Boolean enableIpForwarding) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withEnableIpForwarding(enableIpForwarding);
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityGroup();
    }

    public VirtualMachineNetworkInterfaceConfiguration withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withNetworkSecurityGroup(networkSecurityGroup);
        return this;
    }

    public VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSettings();
    }

    public VirtualMachineNetworkInterfaceConfiguration withDnsSettings(VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withDnsSettings(dnsSettings);
        return this;
    }

    public List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public VirtualMachineNetworkInterfaceConfiguration withIpConfigurations(List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public SubResource dscpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().dscpConfiguration();
    }

    public VirtualMachineNetworkInterfaceConfiguration withDscpConfiguration(SubResource dscpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withDscpConfiguration(dscpConfiguration);
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliaryMode();
    }

    public VirtualMachineNetworkInterfaceConfiguration withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withAuxiliaryMode(auxiliaryMode);
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.innerProperties() == null ? null : this.innerProperties().auxiliarySku();
    }

    public VirtualMachineNetworkInterfaceConfiguration withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
        }
        this.innerProperties().withAuxiliarySku(auxiliarySku);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachineNetworkInterfaceConfiguration"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineNetworkInterfaceConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineNetworkInterfaceConfiguration)jsonReader.readObject(reader -> {
            VirtualMachineNetworkInterfaceConfiguration deserializedVirtualMachineNetworkInterfaceConfiguration = new VirtualMachineNetworkInterfaceConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfiguration.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfiguration.innerProperties = VirtualMachineNetworkInterfaceConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVirtualMachineNetworkInterfaceConfiguration.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineNetworkInterfaceConfiguration;
        });
    }
}

