/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public class GalleryResourceProfileVersionPropertiesBase
implements JsonSerializable<GalleryResourceProfileVersionPropertiesBase> {
    private List<TargetRegion> targetLocations;
    private Boolean excludeFromLatest;
    private OffsetDateTime publishedDate;
    private GalleryProvisioningState provisioningState;
    private ReplicationStatus replicationStatus;

    public List<TargetRegion> targetLocations() {
        return this.targetLocations;
    }

    public GalleryResourceProfileVersionPropertiesBase withTargetLocations(List<TargetRegion> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public GalleryResourceProfileVersionPropertiesBase withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    GalleryResourceProfileVersionPropertiesBase withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    GalleryResourceProfileVersionPropertiesBase withProvisioningState(GalleryProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    GalleryResourceProfileVersionPropertiesBase withReplicationStatus(ReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
        return this;
    }

    public void validate() {
        if (this.targetLocations() != null) {
            this.targetLocations().forEach(e -> e.validate());
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        return jsonWriter.writeEndObject();
    }

    public static GalleryResourceProfileVersionPropertiesBase fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryResourceProfileVersionPropertiesBase)jsonReader.readObject(reader -> {
            GalleryResourceProfileVersionPropertiesBase deserializedGalleryResourceProfileVersionPropertiesBase = new GalleryResourceProfileVersionPropertiesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetLocations".equals(fieldName)) {
                    List targetLocations;
                    deserializedGalleryResourceProfileVersionPropertiesBase.targetLocations = targetLocations = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.excludeFromLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.replicationStatus = ReplicationStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryResourceProfileVersionPropertiesBase;
        });
    }
}

