/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Resource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.azure.resourcemanager.compute.models.AccessLevel;
import com.azure.resourcemanager.compute.models.CopyCompletionError;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.CreationSource;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.Snapshot;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SnapshotImpl
extends GroupableResourceImpl<Snapshot, SnapshotInner, SnapshotImpl, ComputeManager>
implements Snapshot,
Snapshot.Definition,
Snapshot.Update {
    private final ClientLogger logger = new ClientLogger(SnapshotImpl.class);

    SnapshotImpl(String name, SnapshotInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
    }

    @Override
    public SnapshotSkuType skuType() {
        if (((SnapshotInner)((Object)this.innerModel())).sku() == null) {
            return null;
        }
        return SnapshotSkuType.fromSnapshotSku(((SnapshotInner)((Object)this.innerModel())).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((SnapshotInner)((Object)this.innerModel())).creationData().createOption();
    }

    @Override
    public boolean incremental() {
        return ((SnapshotInner)((Object)this.innerModel())).incremental();
    }

    @Override
    public int sizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SnapshotInner)((Object)this.innerModel())).diskSizeGB());
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((SnapshotInner)((Object)this.innerModel())).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((SnapshotInner)((Object)this.innerModel())).creationData());
    }

    @Override
    public Float copyCompletionPercent() {
        return ((SnapshotInner)((Object)this.innerModel())).completionPercent();
    }

    @Override
    public CopyCompletionError copyCompletionError() {
        return ((SnapshotInner)((Object)this.innerModel())).copyCompletionError();
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return (String)this.grantAccessAsync(accessDurationInSeconds).block();
    }

    @Override
    public Mono<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().block();
    }

    @Override
    public Mono<Void> revokeAccessAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().revokeAccessAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void awaitCopyStartCompletion() {
        this.awaitCopyStartCompletionAsync().block();
    }

    @Override
    public Boolean awaitCopyStartCompletion(Duration maxWaitTime) {
        Objects.requireNonNull(maxWaitTime);
        if (maxWaitTime.isNegative() || maxWaitTime.isZero()) {
            throw new IllegalArgumentException(String.format("Max wait time is non-positive: %dms", maxWaitTime.toMillis()));
        }
        return (Boolean)this.awaitCopyStartCompletionAsync().then(Mono.just((Object)Boolean.TRUE)).timeout(maxWaitTime, Mono.just((Object)Boolean.FALSE)).block();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((SnapshotInner)((Object)this.innerModel())).publicNetworkAccess();
    }

    @Override
    public Mono<Void> awaitCopyStartCompletionAsync() {
        if (this.creationMethod() != DiskCreateOption.COPY_START) {
            return Mono.error((Throwable)this.logger.logThrowableAsError((Throwable)new IllegalStateException(String.format("\"awaitCopyStartCompletionAsync\" cannot be called on snapshot \"%s\" when \"creationMethod\" is not \"CopyStart\"", this.name()))));
        }
        return Flux.interval((Duration)Duration.ZERO, (Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval())).flatMap(ignored -> this.getInnerAsync()).flatMap(inner -> {
            this.setInner(inner);
            Mono result = Mono.just((Object)inner);
            if (inner.copyCompletionError() != null) {
                result = Mono.error((Throwable)new ManagementException(inner.copyCompletionError().errorMessage(), null));
            }
            return result;
        }).takeUntil(inner -> {
            if (Float.valueOf(100.0f).equals(inner.completionPercent())) {
                return true;
            }
            this.logger.info("Wait for CopyStart complete for snapshot: {}. Complete percent: {}.", new Object[]{inner.name(), inner.completionPercent()});
            return false;
        }).then();
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl) {
        return this.withLinuxFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl) {
        return this.withWindowsFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl) {
        return this.withDataFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(String snapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(Snapshot snapshot) {
        return this.withDataFromSnapshot(snapshot.id());
    }

    @Override
    public SnapshotImpl withCopyStart() {
        ((SnapshotInner)((Object)this.innerModel())).creationData().withCreateOption(DiskCreateOption.COPY_START);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(String managedDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(Disk managedDisk) {
        return this.withDataFromDisk(managedDisk.id()).withOSType(managedDisk.osType());
    }

    @Override
    public SnapshotImpl withSizeInGB(int sizeInGB) {
        ((SnapshotInner)((Object)this.innerModel())).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public SnapshotImpl withIncremental(boolean enabled) {
        ((SnapshotInner)((Object)this.innerModel())).withIncremental(enabled);
        return this;
    }

    @Override
    public SnapshotImpl withOSType(OperatingSystemTypes osType) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(osType);
        return this;
    }

    @Override
    public SnapshotImpl withSku(SnapshotSkuType sku) {
        ((SnapshotInner)((Object)this.innerModel())).withSku(new SnapshotSku().withName(sku.accountType()));
        return this;
    }

    public Mono<Snapshot> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SnapshotInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<SnapshotInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private String constructStorageAccountId(String vhdUrl) {
        try {
            return ResourceUtils.constructResourceId((String)((ComputeManager)this.manager()).subscriptionId(), (String)this.resourceGroupName(), (String)"Microsoft.Storage", (String)"storageAccounts", (String)vhdUrl.split("\\.")[0].replace("https://", ""), (String)"");
        }
        catch (RuntimeException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("%s is not valid URI of a blob to import.", vhdUrl)));
        }
    }

    @Override
    public SnapshotImpl enablePublicNetworkAccess() {
        ((SnapshotInner)((Object)this.innerModel())).withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        return this;
    }

    @Override
    public SnapshotImpl disablePublicNetworkAccess() {
        ((SnapshotInner)((Object)this.innerModel())).withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        return this;
    }

    @Override
    public Accepted<Snapshot> beginCreate() {
        return this.beginCreate(Context.NONE);
    }

    @Override
    public Accepted<Snapshot> beginCreate(Context context) {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (SnapshotInner)((Object)((Object)this.innerModel()))).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).block(), inner -> new SnapshotImpl(inner.name(), (SnapshotInner)((Object)inner), (ComputeManager)this.manager()), SnapshotInner.class, () -> {
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext()).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly()));
            dependencyTasksAsync.blockLast();
        }, arg_0 -> ((SnapshotImpl)this).setInner(arg_0), (Context)context);
    }
}

