/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AdditionalUnattendContent;
import com.azure.resourcemanager.compute.models.PatchSettings;
import com.azure.resourcemanager.compute.models.WinRMConfiguration;
import java.io.IOException;
import java.util.List;

public final class WindowsConfiguration
implements JsonSerializable<WindowsConfiguration> {
    private Boolean provisionVMAgent;
    private Boolean enableAutomaticUpdates;
    private String timeZone;
    private List<AdditionalUnattendContent> additionalUnattendContent;
    private PatchSettings patchSettings;
    private WinRMConfiguration winRM;
    private Boolean enableVMAgentPlatformUpdates;

    public Boolean provisionVMAgent() {
        return this.provisionVMAgent;
    }

    public WindowsConfiguration withProvisionVMAgent(Boolean provisionVMAgent) {
        this.provisionVMAgent = provisionVMAgent;
        return this;
    }

    public Boolean enableAutomaticUpdates() {
        return this.enableAutomaticUpdates;
    }

    public WindowsConfiguration withEnableAutomaticUpdates(Boolean enableAutomaticUpdates) {
        this.enableAutomaticUpdates = enableAutomaticUpdates;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public WindowsConfiguration withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public List<AdditionalUnattendContent> additionalUnattendContent() {
        return this.additionalUnattendContent;
    }

    public WindowsConfiguration withAdditionalUnattendContent(List<AdditionalUnattendContent> additionalUnattendContent) {
        this.additionalUnattendContent = additionalUnattendContent;
        return this;
    }

    public PatchSettings patchSettings() {
        return this.patchSettings;
    }

    public WindowsConfiguration withPatchSettings(PatchSettings patchSettings) {
        this.patchSettings = patchSettings;
        return this;
    }

    public WinRMConfiguration winRM() {
        return this.winRM;
    }

    public WindowsConfiguration withWinRM(WinRMConfiguration winRM) {
        this.winRM = winRM;
        return this;
    }

    public Boolean enableVMAgentPlatformUpdates() {
        return this.enableVMAgentPlatformUpdates;
    }

    public void validate() {
        if (this.additionalUnattendContent() != null) {
            this.additionalUnattendContent().forEach(e -> e.validate());
        }
        if (this.patchSettings() != null) {
            this.patchSettings().validate();
        }
        if (this.winRM() != null) {
            this.winRM().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("provisionVMAgent", this.provisionVMAgent);
        jsonWriter.writeBooleanField("enableAutomaticUpdates", this.enableAutomaticUpdates);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeArrayField("additionalUnattendContent", this.additionalUnattendContent, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("patchSettings", (JsonSerializable)this.patchSettings);
        jsonWriter.writeJsonField("winRM", (JsonSerializable)this.winRM);
        return jsonWriter.writeEndObject();
    }

    public static WindowsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (WindowsConfiguration)jsonReader.readObject(reader -> {
            WindowsConfiguration deserializedWindowsConfiguration = new WindowsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisionVMAgent".equals(fieldName)) {
                    deserializedWindowsConfiguration.provisionVMAgent = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpdates".equals(fieldName)) {
                    deserializedWindowsConfiguration.enableAutomaticUpdates = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedWindowsConfiguration.timeZone = reader.getString();
                    continue;
                }
                if ("additionalUnattendContent".equals(fieldName)) {
                    List additionalUnattendContent;
                    deserializedWindowsConfiguration.additionalUnattendContent = additionalUnattendContent = reader.readArray(reader1 -> AdditionalUnattendContent.fromJson(reader1));
                    continue;
                }
                if ("patchSettings".equals(fieldName)) {
                    deserializedWindowsConfiguration.patchSettings = PatchSettings.fromJson(reader);
                    continue;
                }
                if ("winRM".equals(fieldName)) {
                    deserializedWindowsConfiguration.winRM = WinRMConfiguration.fromJson(reader);
                    continue;
                }
                if ("enableVMAgentPlatformUpdates".equals(fieldName)) {
                    deserializedWindowsConfiguration.enableVMAgentPlatformUpdates = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWindowsConfiguration;
        });
    }
}

