/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryDiskImage;
import com.azure.resourcemanager.compute.models.GalleryDiskImageSource;
import com.azure.resourcemanager.compute.models.HostCaching;
import java.io.IOException;

public final class GalleryOSDiskImage
extends GalleryDiskImage {
    private Integer sizeInGB;

    @Override
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    @Override
    public GalleryOSDiskImage withHostCaching(HostCaching hostCaching) {
        super.withHostCaching(hostCaching);
        return this;
    }

    @Override
    public GalleryOSDiskImage withSource(GalleryDiskImageSource source) {
        super.withSource(source);
        return this;
    }

    @Override
    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostCaching", this.hostCaching() == null ? null : this.hostCaching().toString());
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source());
        return jsonWriter.writeEndObject();
    }

    public static GalleryOSDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryOSDiskImage)jsonReader.readObject(reader -> {
            GalleryOSDiskImage deserializedGalleryOSDiskImage = new GalleryOSDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeInGB".equals(fieldName)) {
                    deserializedGalleryOSDiskImage.sizeInGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("hostCaching".equals(fieldName)) {
                    deserializedGalleryOSDiskImage.withHostCaching(HostCaching.fromString(reader.getString()));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedGalleryOSDiskImage.withSource(GalleryDiskImageSource.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryOSDiskImage;
        });
    }
}

