/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineImageImpl;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.compute.models.VirtualMachineImages;
import com.azure.resourcemanager.compute.models.VirtualMachinePublishers;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.List;
import reactor.core.publisher.Flux;

public class VirtualMachineImagesImpl
implements VirtualMachineImages {
    private final VirtualMachinePublishers publishers;
    private final VirtualMachineImagesClient client;

    public VirtualMachineImagesImpl(VirtualMachinePublishers publishers, VirtualMachineImagesClient client) {
        this.publishers = publishers;
        this.client = client;
    }

    @Override
    public VirtualMachineImage getImage(Region region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List innerImages;
        if ("latest".equalsIgnoreCase(version) && (innerImages = (List)this.client.listWithResponse(region.name(), publisherName, offerName, skuName, null, 1, "name desc", Context.NONE).getValue()) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = (VirtualMachineImageResourceInner)((Object)innerImages.get(0));
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region.name(), publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(region, publisherName, offerName, skuName, version, innerImage) : null;
    }

    @Override
    public VirtualMachineImage getImage(String region, String publisherName, String offerName, String skuName, String version) {
        VirtualMachineImageInner innerImage;
        List innerImages;
        if ("latest".equalsIgnoreCase(version) && (innerImages = (List)this.client.listWithResponse(region, publisherName, offerName, skuName, null, 1, "name desc", Context.NONE).getValue()) != null && !innerImages.isEmpty()) {
            VirtualMachineImageResourceInner innerImageResource = (VirtualMachineImageResourceInner)((Object)innerImages.get(0));
            version = innerImageResource.name();
        }
        return (innerImage = this.client.get(region, publisherName, offerName, skuName, version)) != null ? new VirtualMachineImageImpl(Region.fromName((String)region), publisherName, offerName, skuName, version, innerImage) : null;
    }

    public PagedIterable<VirtualMachineImage> listByRegion(Region location) {
        return this.listByRegion(location.toString());
    }

    public PagedIterable<VirtualMachineImage> listByRegion(String regionName) {
        return new PagedIterable(this.listByRegionAsync(regionName));
    }

    public PagedFlux<VirtualMachineImage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public PagedFlux<VirtualMachineImage> listByRegionAsync(String regionName) {
        return PagedConverter.flatMapPage((PagedFlux)this.publishers().listByRegionAsync(regionName), virtualMachinePublisher -> virtualMachinePublisher.offers().listAsync().onErrorResume(ManagementException.class, e -> e.getResponse().getStatusCode() == 404 ? Flux.empty() : Flux.error((Throwable)e)).flatMap(virtualMachineOffer -> virtualMachineOffer.skus().listAsync()).flatMap(virtualMachineSku -> virtualMachineSku.images().listAsync()));
    }

    @Override
    public VirtualMachinePublishers publishers() {
        return this.publishers;
    }
}

