/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.ResilientVMDeletionStatus;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProtectionPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class VirtualMachineScaleSetVMPropertiesInner
implements JsonSerializable<VirtualMachineScaleSetVMPropertiesInner> {
    private Boolean latestModelApplied;
    private String vmId;
    private VirtualMachineScaleSetVMInstanceViewInner instanceView;
    private HardwareProfile hardwareProfile;
    private ResilientVMDeletionStatus resilientVMDeletionStatus;
    private StorageProfile storageProfile;
    private AdditionalCapabilities additionalCapabilities;
    private OSProfile osProfile;
    private SecurityProfile securityProfile;
    private NetworkProfile networkProfile;
    private VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration;
    private DiagnosticsProfile diagnosticsProfile;
    private SubResource availabilitySet;
    private String provisioningState;
    private String licenseType;
    private String modelDefinitionApplied;
    private VirtualMachineScaleSetVMProtectionPolicy protectionPolicy;
    private String userData;
    private OffsetDateTime timeCreated;

    public Boolean latestModelApplied() {
        return this.latestModelApplied;
    }

    public String vmId() {
        return this.vmId;
    }

    public VirtualMachineScaleSetVMInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public ResilientVMDeletionStatus resilientVMDeletionStatus() {
        return this.resilientVMDeletionStatus;
    }

    public VirtualMachineScaleSetVMPropertiesInner withResilientVMDeletionStatus(ResilientVMDeletionStatus resilientVMDeletionStatus) {
        this.resilientVMDeletionStatus = resilientVMDeletionStatus;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetVMPropertiesInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return this.networkProfileConfiguration;
    }

    public VirtualMachineScaleSetVMPropertiesInner withNetworkProfileConfiguration(VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration) {
        this.networkProfileConfiguration = networkProfileConfiguration;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachineScaleSetVMPropertiesInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachineScaleSetVMPropertiesInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineScaleSetVMPropertiesInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String modelDefinitionApplied() {
        return this.modelDefinitionApplied;
    }

    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return this.protectionPolicy;
    }

    public VirtualMachineScaleSetVMPropertiesInner withProtectionPolicy(VirtualMachineScaleSetVMProtectionPolicy protectionPolicy) {
        this.protectionPolicy = protectionPolicy;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachineScaleSetVMPropertiesInner withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.networkProfileConfiguration() != null) {
            this.networkProfileConfiguration().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.protectionPolicy() != null) {
            this.protectionPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeStringField("resilientVMDeletionStatus", this.resilientVMDeletionStatus == null ? null : this.resilientVMDeletionStatus.toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("additionalCapabilities", (JsonSerializable)this.additionalCapabilities);
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("networkProfileConfiguration", (JsonSerializable)this.networkProfileConfiguration);
        jsonWriter.writeJsonField("diagnosticsProfile", (JsonSerializable)this.diagnosticsProfile);
        jsonWriter.writeJsonField("availabilitySet", (JsonSerializable)this.availabilitySet);
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeJsonField("protectionPolicy", (JsonSerializable)this.protectionPolicy);
        jsonWriter.writeStringField("userData", this.userData);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetVMPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetVMPropertiesInner)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMPropertiesInner deserializedVirtualMachineScaleSetVMPropertiesInner = new VirtualMachineScaleSetVMPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latestModelApplied".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.latestModelApplied = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vmId".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.vmId = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.instanceView = VirtualMachineScaleSetVMInstanceViewInner.fromJson(reader);
                    continue;
                }
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.hardwareProfile = HardwareProfile.fromJson(reader);
                    continue;
                }
                if ("resilientVMDeletionStatus".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.resilientVMDeletionStatus = ResilientVMDeletionStatus.fromString(reader.getString());
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                if ("additionalCapabilities".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.additionalCapabilities = AdditionalCapabilities.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.osProfile = OSProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfileConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.networkProfileConfiguration = VirtualMachineScaleSetVMNetworkProfileConfiguration.fromJson(reader);
                    continue;
                }
                if ("diagnosticsProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.diagnosticsProfile = DiagnosticsProfile.fromJson(reader);
                    continue;
                }
                if ("availabilitySet".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.availabilitySet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.provisioningState = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.licenseType = reader.getString();
                    continue;
                }
                if ("modelDefinitionApplied".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.modelDefinitionApplied = reader.getString();
                    continue;
                }
                if ("protectionPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.protectionPolicy = VirtualMachineScaleSetVMProtectionPolicy.fromJson(reader);
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.userData = reader.getString();
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMPropertiesInner.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetVMPropertiesInner;
        });
    }
}

