/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryIdentifier;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryImageVersionProperties;
import com.azure.resourcemanager.compute.models.PirSharedGalleryResource;
import com.azure.resourcemanager.compute.models.SharedGalleryImageVersionStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SharedGalleryImageVersionInner
extends PirSharedGalleryResource {
    private SharedGalleryImageVersionProperties innerProperties;
    private SharedGalleryIdentifier innerIdentifier;
    private String location;
    private String name;

    private SharedGalleryImageVersionProperties innerProperties() {
        return this.innerProperties;
    }

    private SharedGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    @Override
    public SharedGalleryImageVersionInner withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new SharedGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    public OffsetDateTime publishedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDate();
    }

    public SharedGalleryImageVersionInner withPublishedDate(OffsetDateTime publishedDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withPublishedDate(publishedDate);
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.innerProperties() == null ? null : this.innerProperties().endOfLifeDate();
    }

    public SharedGalleryImageVersionInner withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeFromLatest();
    }

    public SharedGalleryImageVersionInner withExcludeFromLatest(Boolean excludeFromLatest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    public SharedGalleryImageVersionStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public SharedGalleryImageVersionInner withStorageProfile(SharedGalleryImageVersionStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.innerProperties() == null ? null : this.innerProperties().artifactTags();
    }

    public SharedGalleryImageVersionInner withArtifactTags(Map<String, String> artifactTags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SharedGalleryImageVersionProperties();
        }
        this.innerProperties().withArtifactTags(artifactTags);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.innerIdentifier() != null) {
            this.innerIdentifier().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.innerIdentifier());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryImageVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SharedGalleryImageVersionInner)jsonReader.readObject(reader -> {
            SharedGalleryImageVersionInner deserializedSharedGalleryImageVersionInner = new SharedGalleryImageVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.location = reader.getString();
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.innerIdentifier = SharedGalleryIdentifier.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionInner.innerProperties = SharedGalleryImageVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryImageVersionInner;
        });
    }
}

