/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskAccessProperties;
import com.azure.resourcemanager.compute.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DiskAccessInner
extends Resource {
    private DiskAccessProperties innerProperties;
    private ExtendedLocation extendedLocation;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private DiskAccessProperties innerProperties() {
        return this.innerProperties;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public DiskAccessInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DiskAccessInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiskAccessInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static DiskAccessInner fromJson(JsonReader jsonReader) throws IOException {
        return (DiskAccessInner)((Object)jsonReader.readObject(reader -> {
            DiskAccessInner deserializedDiskAccessInner = new DiskAccessInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiskAccessInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiskAccessInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiskAccessInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDiskAccessInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDiskAccessInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDiskAccessInner.innerProperties = DiskAccessProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedDiskAccessInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDiskAccessInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskAccessInner;
        }));
    }
}

