/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.VMDiskSecurityProfile;
import java.io.IOException;

public final class VirtualMachineScaleSetManagedDiskParameters
implements JsonSerializable<VirtualMachineScaleSetManagedDiskParameters> {
    private StorageAccountTypes storageAccountType;
    private DiskEncryptionSetParameters diskEncryptionSet;
    private VMDiskSecurityProfile securityProfile;

    public StorageAccountTypes storageAccountType() {
        return this.storageAccountType;
    }

    public VirtualMachineScaleSetManagedDiskParameters withStorageAccountType(StorageAccountTypes storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public VirtualMachineScaleSetManagedDiskParameters withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public VMDiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineScaleSetManagedDiskParameters withSecurityProfile(VMDiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetManagedDiskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetManagedDiskParameters)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetManagedDiskParameters deserializedVirtualMachineScaleSetManagedDiskParameters = new VirtualMachineScaleSetManagedDiskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetManagedDiskParameters.storageAccountType = StorageAccountTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetManagedDiskParameters.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetManagedDiskParameters.securityProfile = VMDiskSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetManagedDiskParameters;
        });
    }
}

