/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.PrivateEndpointConnectionInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiskAccessProperties
implements JsonSerializable<DiskAccessProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private String provisioningState;
    private OffsetDateTime timeCreated;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DiskAccessProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiskAccessProperties)jsonReader.readObject(reader -> {
            DiskAccessProperties deserializedDiskAccessProperties = new DiskAccessProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedDiskAccessProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDiskAccessProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedDiskAccessProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskAccessProperties;
        });
    }
}

