/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.SnapshotsClient;
import com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.azure.resourcemanager.compute.implementation.SnapshotImpl;
import com.azure.resourcemanager.compute.models.AccessLevel;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.compute.models.Snapshot;
import com.azure.resourcemanager.compute.models.Snapshots;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import java.time.Duration;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class SnapshotsImpl
extends TopLevelModifiableResourcesImpl<Snapshot, SnapshotImpl, SnapshotInner, SnapshotsClient, ComputeManager>
implements Snapshots {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public SnapshotsImpl(ComputeManager computeManager) {
        super((InnerSupportsListing)((ComputeManagementClient)computeManager.serviceClient()).getSnapshots(), (Manager)computeManager);
    }

    @Override
    public Mono<String> grantAccessAsync(String resourceGroupName, String snapshotName, AccessLevel accessLevel, int accessDuration) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(accessLevel).withDurationInSeconds(accessDuration);
        return ((SnapshotsClient)this.inner()).grantAccessAsync(resourceGroupName, snapshotName, grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public String grantAccess(String resourceGroupName, String snapshotName, AccessLevel accessLevel, int accessDuration) {
        return (String)this.grantAccessAsync(resourceGroupName, snapshotName, accessLevel, accessDuration).block();
    }

    @Override
    public Mono<Void> revokeAccessAsync(String resourceGroupName, String snapName) {
        return ((SnapshotsClient)this.inner()).revokeAccessAsync(resourceGroupName, snapName);
    }

    @Override
    public void revokeAccess(String resourceGroupName, String snapName) {
        this.revokeAccessAsync(resourceGroupName, snapName).block();
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        return this.beginDeleteById(id, Context.NONE);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id, Context context) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), context);
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name) {
        return this.beginDeleteByResourceGroup(resourceGroupName, name, Context.NONE);
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name, Context context) {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((SnapshotsClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).block(), Function.identity(), Void.class, null, (Context)context);
    }

    protected SnapshotImpl wrapModel(String name) {
        return new SnapshotImpl(name, new SnapshotInner(), (ComputeManager)this.manager());
    }

    protected SnapshotImpl wrapModel(SnapshotInner inner) {
        if (inner == null) {
            return null;
        }
        return new SnapshotImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    public Snapshot.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }
}

