/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceVaultSecretGroup;
import java.io.IOException;
import java.util.List;

public final class CloudServiceOsProfile
implements JsonSerializable<CloudServiceOsProfile> {
    private List<CloudServiceVaultSecretGroup> secrets;

    public List<CloudServiceVaultSecretGroup> secrets() {
        return this.secrets;
    }

    public CloudServiceOsProfile withSecrets(List<CloudServiceVaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceOsProfile fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceOsProfile)jsonReader.readObject(reader -> {
            CloudServiceOsProfile deserializedCloudServiceOsProfile = new CloudServiceOsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedCloudServiceOsProfile.secrets = secrets = reader.readArray(reader1 -> CloudServiceVaultSecretGroup.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceOsProfile;
        });
    }
}

