/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ExecutedValidation;
import com.azure.resourcemanager.compute.models.PlatformAttribute;
import java.io.IOException;
import java.util.List;

public final class ValidationsProfile
implements JsonSerializable<ValidationsProfile> {
    private String validationEtag;
    private List<ExecutedValidation> executedValidations;
    private List<PlatformAttribute> platformAttributes;

    public String validationEtag() {
        return this.validationEtag;
    }

    public ValidationsProfile withValidationEtag(String validationEtag) {
        this.validationEtag = validationEtag;
        return this;
    }

    public List<ExecutedValidation> executedValidations() {
        return this.executedValidations;
    }

    public ValidationsProfile withExecutedValidations(List<ExecutedValidation> executedValidations) {
        this.executedValidations = executedValidations;
        return this;
    }

    public List<PlatformAttribute> platformAttributes() {
        return this.platformAttributes;
    }

    public ValidationsProfile withPlatformAttributes(List<PlatformAttribute> platformAttributes) {
        this.platformAttributes = platformAttributes;
        return this;
    }

    public void validate() {
        if (this.executedValidations() != null) {
            this.executedValidations().forEach(e -> e.validate());
        }
        if (this.platformAttributes() != null) {
            this.platformAttributes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationEtag", this.validationEtag);
        jsonWriter.writeArrayField("executedValidations", this.executedValidations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("platformAttributes", this.platformAttributes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ValidationsProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationsProfile)jsonReader.readObject(reader -> {
            ValidationsProfile deserializedValidationsProfile = new ValidationsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("validationEtag".equals(fieldName)) {
                    deserializedValidationsProfile.validationEtag = reader.getString();
                    continue;
                }
                if ("executedValidations".equals(fieldName)) {
                    List executedValidations;
                    deserializedValidationsProfile.executedValidations = executedValidations = reader.readArray(reader1 -> ExecutedValidation.fromJson(reader1));
                    continue;
                }
                if ("platformAttributes".equals(fieldName)) {
                    List platformAttributes;
                    deserializedValidationsProfile.platformAttributes = platformAttributes = reader.readArray(reader1 -> PlatformAttribute.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationsProfile;
        });
    }
}

