/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.EncryptionImages;
import com.azure.resourcemanager.compute.models.GalleryExtendedLocation;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import java.io.IOException;

public final class GalleryTargetExtendedLocation
implements JsonSerializable<GalleryTargetExtendedLocation> {
    private String name;
    private GalleryExtendedLocation extendedLocation;
    private Integer extendedLocationReplicaCount;
    private StorageAccountType storageAccountType;
    private EncryptionImages encryption;

    public String name() {
        return this.name;
    }

    public GalleryTargetExtendedLocation withName(String name) {
        this.name = name;
        return this;
    }

    public GalleryExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public GalleryTargetExtendedLocation withExtendedLocation(GalleryExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public Integer extendedLocationReplicaCount() {
        return this.extendedLocationReplicaCount;
    }

    public GalleryTargetExtendedLocation withExtendedLocationReplicaCount(Integer extendedLocationReplicaCount) {
        this.extendedLocationReplicaCount = extendedLocationReplicaCount;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public GalleryTargetExtendedLocation withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public EncryptionImages encryption() {
        return this.encryption;
    }

    public GalleryTargetExtendedLocation withEncryption(EncryptionImages encryption) {
        this.encryption = encryption;
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeNumberField("extendedLocationReplicaCount", (Number)this.extendedLocationReplicaCount);
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        return jsonWriter.writeEndObject();
    }

    public static GalleryTargetExtendedLocation fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryTargetExtendedLocation)jsonReader.readObject(reader -> {
            GalleryTargetExtendedLocation deserializedGalleryTargetExtendedLocation = new GalleryTargetExtendedLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGalleryTargetExtendedLocation.name = reader.getString();
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedGalleryTargetExtendedLocation.extendedLocation = GalleryExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("extendedLocationReplicaCount".equals(fieldName)) {
                    deserializedGalleryTargetExtendedLocation.extendedLocationReplicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryTargetExtendedLocation.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedGalleryTargetExtendedLocation.encryption = EncryptionImages.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryTargetExtendedLocation;
        });
    }
}

