/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApplicationProfile;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.CapacityReservationProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.ScheduledEventsProfile;
import com.azure.resourcemanager.compute.models.SecurityPostureReference;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.ServiceArtifactReference;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetExtensionProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetHardwareProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetOSProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class VirtualMachineScaleSetVMProfile
implements JsonSerializable<VirtualMachineScaleSetVMProfile> {
    private VirtualMachineScaleSetOSProfile osProfile;
    private VirtualMachineScaleSetStorageProfile storageProfile;
    private VirtualMachineScaleSetNetworkProfile networkProfile;
    private SecurityProfile securityProfile;
    private DiagnosticsProfile diagnosticsProfile;
    private VirtualMachineScaleSetExtensionProfile extensionProfile;
    private String licenseType;
    private VirtualMachinePriorityTypes priority;
    private VirtualMachineEvictionPolicyTypes evictionPolicy;
    private BillingProfile billingProfile;
    private ScheduledEventsProfile scheduledEventsProfile;
    private String userData;
    private CapacityReservationProfile capacityReservation;
    private ApplicationProfile applicationProfile;
    private VirtualMachineScaleSetHardwareProfile hardwareProfile;
    private ServiceArtifactReference serviceArtifactReference;
    private SecurityPostureReference securityPostureReference;
    private OffsetDateTime timeCreated;

    public VirtualMachineScaleSetOSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineScaleSetVMProfile withOsProfile(VirtualMachineScaleSetOSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public VirtualMachineScaleSetStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineScaleSetVMProfile withStorageProfile(VirtualMachineScaleSetStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public VirtualMachineScaleSetNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineScaleSetVMProfile withNetworkProfile(VirtualMachineScaleSetNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineScaleSetVMProfile withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachineScaleSetVMProfile withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public VirtualMachineScaleSetExtensionProfile extensionProfile() {
        return this.extensionProfile;
    }

    public VirtualMachineScaleSetVMProfile withExtensionProfile(VirtualMachineScaleSetExtensionProfile extensionProfile) {
        this.extensionProfile = extensionProfile;
        return this;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineScaleSetVMProfile withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.priority;
    }

    public VirtualMachineScaleSetVMProfile withPriority(VirtualMachinePriorityTypes priority) {
        this.priority = priority;
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.evictionPolicy;
    }

    public VirtualMachineScaleSetVMProfile withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BillingProfile billingProfile() {
        return this.billingProfile;
    }

    public VirtualMachineScaleSetVMProfile withBillingProfile(BillingProfile billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.scheduledEventsProfile;
    }

    public VirtualMachineScaleSetVMProfile withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        this.scheduledEventsProfile = scheduledEventsProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachineScaleSetVMProfile withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public CapacityReservationProfile capacityReservation() {
        return this.capacityReservation;
    }

    public VirtualMachineScaleSetVMProfile withCapacityReservation(CapacityReservationProfile capacityReservation) {
        this.capacityReservation = capacityReservation;
        return this;
    }

    public ApplicationProfile applicationProfile() {
        return this.applicationProfile;
    }

    public VirtualMachineScaleSetVMProfile withApplicationProfile(ApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
        return this;
    }

    public VirtualMachineScaleSetHardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineScaleSetVMProfile withHardwareProfile(VirtualMachineScaleSetHardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public ServiceArtifactReference serviceArtifactReference() {
        return this.serviceArtifactReference;
    }

    public VirtualMachineScaleSetVMProfile withServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    public SecurityPostureReference securityPostureReference() {
        return this.securityPostureReference;
    }

    public VirtualMachineScaleSetVMProfile withSecurityPostureReference(SecurityPostureReference securityPostureReference) {
        this.securityPostureReference = securityPostureReference;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.extensionProfile() != null) {
            this.extensionProfile().validate();
        }
        if (this.billingProfile() != null) {
            this.billingProfile().validate();
        }
        if (this.scheduledEventsProfile() != null) {
            this.scheduledEventsProfile().validate();
        }
        if (this.capacityReservation() != null) {
            this.capacityReservation().validate();
        }
        if (this.applicationProfile() != null) {
            this.applicationProfile().validate();
        }
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.serviceArtifactReference() != null) {
            this.serviceArtifactReference().validate();
        }
        if (this.securityPostureReference() != null) {
            this.securityPostureReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("diagnosticsProfile", (JsonSerializable)this.diagnosticsProfile);
        jsonWriter.writeJsonField("extensionProfile", (JsonSerializable)this.extensionProfile);
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeStringField("priority", this.priority == null ? null : this.priority.toString());
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy == null ? null : this.evictionPolicy.toString());
        jsonWriter.writeJsonField("billingProfile", (JsonSerializable)this.billingProfile);
        jsonWriter.writeJsonField("scheduledEventsProfile", (JsonSerializable)this.scheduledEventsProfile);
        jsonWriter.writeStringField("userData", this.userData);
        jsonWriter.writeJsonField("capacityReservation", (JsonSerializable)this.capacityReservation);
        jsonWriter.writeJsonField("applicationProfile", (JsonSerializable)this.applicationProfile);
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeJsonField("serviceArtifactReference", (JsonSerializable)this.serviceArtifactReference);
        jsonWriter.writeJsonField("securityPostureReference", (JsonSerializable)this.securityPostureReference);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetVMProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetVMProfile)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMProfile deserializedVirtualMachineScaleSetVMProfile = new VirtualMachineScaleSetVMProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.osProfile = VirtualMachineScaleSetOSProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.storageProfile = VirtualMachineScaleSetStorageProfile.fromJson(reader);
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.networkProfile = VirtualMachineScaleSetNetworkProfile.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("diagnosticsProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.diagnosticsProfile = DiagnosticsProfile.fromJson(reader);
                    continue;
                }
                if ("extensionProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.extensionProfile = VirtualMachineScaleSetExtensionProfile.fromJson(reader);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.licenseType = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.priority = VirtualMachinePriorityTypes.fromString(reader.getString());
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.evictionPolicy = VirtualMachineEvictionPolicyTypes.fromString(reader.getString());
                    continue;
                }
                if ("billingProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.billingProfile = BillingProfile.fromJson(reader);
                    continue;
                }
                if ("scheduledEventsProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.scheduledEventsProfile = ScheduledEventsProfile.fromJson(reader);
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.userData = reader.getString();
                    continue;
                }
                if ("capacityReservation".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.capacityReservation = CapacityReservationProfile.fromJson(reader);
                    continue;
                }
                if ("applicationProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.applicationProfile = ApplicationProfile.fromJson(reader);
                    continue;
                }
                if ("hardwareProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.hardwareProfile = VirtualMachineScaleSetHardwareProfile.fromJson(reader);
                    continue;
                }
                if ("serviceArtifactReference".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.serviceArtifactReference = ServiceArtifactReference.fromJson(reader);
                    continue;
                }
                if ("securityPostureReference".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.securityPostureReference = SecurityPostureReference.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMProfile.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetVMProfile;
        });
    }
}

