/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.UefiKey;
import java.io.IOException;
import java.util.List;

public final class UefiKeySignatures
implements JsonSerializable<UefiKeySignatures> {
    private UefiKey pk;
    private List<UefiKey> kek;
    private List<UefiKey> db;
    private List<UefiKey> dbx;

    public UefiKey pk() {
        return this.pk;
    }

    public UefiKeySignatures withPk(UefiKey pk) {
        this.pk = pk;
        return this;
    }

    public List<UefiKey> kek() {
        return this.kek;
    }

    public UefiKeySignatures withKek(List<UefiKey> kek) {
        this.kek = kek;
        return this;
    }

    public List<UefiKey> db() {
        return this.db;
    }

    public UefiKeySignatures withDb(List<UefiKey> db) {
        this.db = db;
        return this;
    }

    public List<UefiKey> dbx() {
        return this.dbx;
    }

    public UefiKeySignatures withDbx(List<UefiKey> dbx) {
        this.dbx = dbx;
        return this;
    }

    public void validate() {
        if (this.pk() != null) {
            this.pk().validate();
        }
        if (this.kek() != null) {
            this.kek().forEach(e -> e.validate());
        }
        if (this.db() != null) {
            this.db().forEach(e -> e.validate());
        }
        if (this.dbx() != null) {
            this.dbx().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("pk", (JsonSerializable)this.pk);
        jsonWriter.writeArrayField("kek", this.kek, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("db", this.db, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dbx", this.dbx, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static UefiKeySignatures fromJson(JsonReader jsonReader) throws IOException {
        return (UefiKeySignatures)jsonReader.readObject(reader -> {
            UefiKeySignatures deserializedUefiKeySignatures = new UefiKeySignatures();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pk".equals(fieldName)) {
                    deserializedUefiKeySignatures.pk = UefiKey.fromJson(reader);
                    continue;
                }
                if ("kek".equals(fieldName)) {
                    List kek;
                    deserializedUefiKeySignatures.kek = kek = reader.readArray(reader1 -> UefiKey.fromJson(reader1));
                    continue;
                }
                if ("db".equals(fieldName)) {
                    List db;
                    deserializedUefiKeySignatures.db = db = reader.readArray(reader1 -> UefiKey.fromJson(reader1));
                    continue;
                }
                if ("dbx".equals(fieldName)) {
                    List dbx;
                    deserializedUefiKeySignatures.dbx = dbx = reader.readArray(reader1 -> UefiKey.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUefiKeySignatures;
        });
    }
}

