/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.StatusLevelTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class InstanceViewStatus
implements JsonSerializable<InstanceViewStatus> {
    private String code;
    private StatusLevelTypes level;
    private String displayStatus;
    private String message;
    private OffsetDateTime time;

    public String code() {
        return this.code;
    }

    public InstanceViewStatus withCode(String code) {
        this.code = code;
        return this;
    }

    public StatusLevelTypes level() {
        return this.level;
    }

    public InstanceViewStatus withLevel(StatusLevelTypes level) {
        this.level = level;
        return this;
    }

    public String displayStatus() {
        return this.displayStatus;
    }

    public InstanceViewStatus withDisplayStatus(String displayStatus) {
        this.displayStatus = displayStatus;
        return this;
    }

    public String message() {
        return this.message;
    }

    public InstanceViewStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public InstanceViewStatus withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("displayStatus", this.displayStatus);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        return jsonWriter.writeEndObject();
    }

    public static InstanceViewStatus fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceViewStatus)jsonReader.readObject(reader -> {
            InstanceViewStatus deserializedInstanceViewStatus = new InstanceViewStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedInstanceViewStatus.code = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedInstanceViewStatus.level = StatusLevelTypes.fromString(reader.getString());
                    continue;
                }
                if ("displayStatus".equals(fieldName)) {
                    deserializedInstanceViewStatus.displayStatus = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedInstanceViewStatus.message = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedInstanceViewStatus.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceViewStatus;
        });
    }
}

