/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CapacityReservationInstanceView;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CapacityReservationProperties
implements JsonSerializable<CapacityReservationProperties> {
    private String reservationId;
    private Integer platformFaultDomainCount;
    private List<SubResourceReadOnly> virtualMachinesAssociated;
    private OffsetDateTime provisioningTime;
    private String provisioningState;
    private CapacityReservationInstanceView instanceView;
    private OffsetDateTime timeCreated;

    public String reservationId() {
        return this.reservationId;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public CapacityReservationInstanceView instanceView() {
        return this.instanceView;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.virtualMachinesAssociated() != null) {
            this.virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityReservationProperties)jsonReader.readObject(reader -> {
            CapacityReservationProperties deserializedCapacityReservationProperties = new CapacityReservationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("reservationId".equals(fieldName)) {
                    deserializedCapacityReservationProperties.reservationId = reader.getString();
                    continue;
                }
                if ("platformFaultDomainCount".equals(fieldName)) {
                    deserializedCapacityReservationProperties.platformFaultDomainCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("virtualMachinesAssociated".equals(fieldName)) {
                    List virtualMachinesAssociated;
                    deserializedCapacityReservationProperties.virtualMachinesAssociated = virtualMachinesAssociated = reader.readArray(reader1 -> SubResourceReadOnly.fromJson(reader1));
                    continue;
                }
                if ("provisioningTime".equals(fieldName)) {
                    deserializedCapacityReservationProperties.provisioningTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCapacityReservationProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedCapacityReservationProperties.instanceView = CapacityReservationInstanceView.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedCapacityReservationProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationProperties;
        });
    }
}

