/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.IpVersion;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIpTag;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetPublicIpAddressConfigurationProperties
implements JsonSerializable<VirtualMachineScaleSetPublicIpAddressConfigurationProperties> {
    private Integer idleTimeoutInMinutes;
    private VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings;
    private List<VirtualMachineScaleSetIpTag> ipTags;
    private SubResource publicIpPrefix;
    private IpVersion publicIpAddressVersion;
    private DeleteOptions deleteOption;

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withDnsSettings(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineScaleSetIpTag> ipTags() {
        return this.ipTags;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withIpTags(List<VirtualMachineScaleSetIpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeArrayField("ipTags", this.ipTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("publicIPPrefix", (JsonSerializable)this.publicIpPrefix);
        jsonWriter.writeStringField("publicIPAddressVersion", this.publicIpAddressVersion == null ? null : this.publicIpAddressVersion.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetPublicIpAddressConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetPublicIpAddressConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetPublicIpAddressConfigurationProperties deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties = new VirtualMachineScaleSetPublicIpAddressConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.dnsSettings = VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.fromJson(reader);
                    continue;
                }
                if ("ipTags".equals(fieldName)) {
                    List ipTags;
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.ipTags = ipTags = reader.readArray(reader1 -> VirtualMachineScaleSetIpTag.fromJson(reader1));
                    continue;
                }
                if ("publicIPPrefix".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.publicIpPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("publicIPAddressVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.publicIpAddressVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetPublicIpAddressConfigurationProperties;
        });
    }
}

