/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInner;
import com.azure.resourcemanager.compute.models.Gallery;
import com.azure.resourcemanager.compute.models.GalleryImage;
import com.azure.resourcemanager.compute.models.GalleryUpdate;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import reactor.core.publisher.Mono;

class GalleryImpl
extends GroupableResourceImpl<Gallery, GalleryInner, GalleryImpl, ComputeManager>
implements Gallery,
Gallery.Definition,
Gallery.Update {
    private GalleryUpdate updateParameters = new GalleryUpdate();

    GalleryImpl(String name, GalleryInner inner, ComputeManager manager) {
        super(name, (Resource)inner, (Manager)manager);
    }

    public Mono<Gallery> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getGalleries().createOrUpdateAsync(this.resourceGroupName(), this.name(), (GalleryInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<Gallery> updateResourceAsync() {
        if (((GalleryInner)((Object)this.innerModel())).tags() != null) {
            this.updateParameters.withTags(((GalleryInner)((Object)this.innerModel())).tags());
        }
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getGalleries().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public GalleryImpl update() {
        this.updateParameters = new GalleryUpdate();
        return (GalleryImpl)super.update();
    }

    protected Mono<GalleryInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getGalleries().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public boolean isInCreateMode() {
        return ((GalleryInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String description() {
        return ((GalleryInner)((Object)this.innerModel())).description();
    }

    @Override
    public String uniqueName() {
        return ((GalleryInner)((Object)this.innerModel())).identifier().uniqueName();
    }

    @Override
    public String provisioningState() {
        return ((GalleryInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public Mono<GalleryImage> getImageAsync(String imageName) {
        return ((ComputeManager)this.manager()).galleryImages().getByGalleryAsync(this.resourceGroupName(), this.name(), imageName);
    }

    @Override
    public GalleryImage getImage(String imageName) {
        return ((ComputeManager)this.manager()).galleryImages().getByGallery(this.resourceGroupName(), this.name(), imageName);
    }

    @Override
    public PagedFlux<GalleryImage> listImagesAsync() {
        return ((ComputeManager)this.manager()).galleryImages().listByGalleryAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedIterable<GalleryImage> listImages() {
        return ((ComputeManager)this.manager()).galleryImages().listByGallery(this.resourceGroupName(), this.name());
    }

    @Override
    public GalleryImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            ((GalleryInner)((Object)this.innerModel())).withDescription(description);
        } else {
            this.updateParameters.withDescription(description);
        }
        return this;
    }
}

