/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.IpVersion;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIpTag;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineScaleSetPublicIpAddressConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetPublicIpAddressConfiguration.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;
    @JsonProperty(value="properties.dnsSettings")
    private VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings;
    @JsonProperty(value="properties.ipTags")
    private List<VirtualMachineScaleSetIpTag> ipTags;
    @JsonProperty(value="properties.publicIPPrefix")
    private SubResource publicIpPrefix;
    @JsonProperty(value="properties.publicIPAddressVersion")
    private IpVersion publicIpAddressVersion;

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withDnsSettings(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineScaleSetIpTag> ipTags() {
        return this.ipTags;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withIpTags(List<VirtualMachineScaleSetIpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public VirtualMachineScaleSetPublicIpAddressConfiguration withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachineScaleSetPublicIpAddressConfiguration"));
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
    }
}

