/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.ImageDiskReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CreationData {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CreationData.class);
    @JsonProperty(value="createOption", required=true)
    private DiskCreateOption createOption;
    @JsonProperty(value="storageAccountId")
    private String storageAccountId;
    @JsonProperty(value="imageReference")
    private ImageDiskReference imageReference;
    @JsonProperty(value="galleryImageReference")
    private ImageDiskReference galleryImageReference;
    @JsonProperty(value="sourceUri")
    private String sourceUri;
    @JsonProperty(value="sourceResourceId")
    private String sourceResourceId;
    @JsonProperty(value="sourceUniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceUniqueId;
    @JsonProperty(value="uploadSizeBytes")
    private Long uploadSizeBytes;
    @JsonProperty(value="logicalSectorSize")
    private Integer logicalSectorSize;

    public DiskCreateOption createOption() {
        return this.createOption;
    }

    public CreationData withCreateOption(DiskCreateOption createOption) {
        this.createOption = createOption;
        return this;
    }

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public CreationData withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public ImageDiskReference imageReference() {
        return this.imageReference;
    }

    public CreationData withImageReference(ImageDiskReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public ImageDiskReference galleryImageReference() {
        return this.galleryImageReference;
    }

    public CreationData withGalleryImageReference(ImageDiskReference galleryImageReference) {
        this.galleryImageReference = galleryImageReference;
        return this;
    }

    public String sourceUri() {
        return this.sourceUri;
    }

    public CreationData withSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public CreationData withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    public Long uploadSizeBytes() {
        return this.uploadSizeBytes;
    }

    public CreationData withUploadSizeBytes(Long uploadSizeBytes) {
        this.uploadSizeBytes = uploadSizeBytes;
        return this;
    }

    public Integer logicalSectorSize() {
        return this.logicalSectorSize;
    }

    public CreationData withLogicalSectorSize(Integer logicalSectorSize) {
        this.logicalSectorSize = logicalSectorSize;
        return this;
    }

    public void validate() {
        if (this.createOption() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property createOption in model CreationData"));
        }
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.galleryImageReference() != null) {
            this.galleryImageReference().validate();
        }
    }
}

