/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.AvailablePatchSummary;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.LastPatchInstallationSummary;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachinePatchStatus {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachinePatchStatus.class);
    @JsonProperty(value="availablePatchSummary")
    private AvailablePatchSummary availablePatchSummary;
    @JsonProperty(value="lastPatchInstallationSummary")
    private LastPatchInstallationSummary lastPatchInstallationSummary;
    @JsonProperty(value="configurationStatuses", access=JsonProperty.Access.WRITE_ONLY)
    private List<InstanceViewStatus> configurationStatuses;

    public AvailablePatchSummary availablePatchSummary() {
        return this.availablePatchSummary;
    }

    public VirtualMachinePatchStatus withAvailablePatchSummary(AvailablePatchSummary availablePatchSummary) {
        this.availablePatchSummary = availablePatchSummary;
        return this;
    }

    public LastPatchInstallationSummary lastPatchInstallationSummary() {
        return this.lastPatchInstallationSummary;
    }

    public VirtualMachinePatchStatus withLastPatchInstallationSummary(LastPatchInstallationSummary lastPatchInstallationSummary) {
        this.lastPatchInstallationSummary = lastPatchInstallationSummary;
        return this;
    }

    public List<InstanceViewStatus> configurationStatuses() {
        return this.configurationStatuses;
    }

    public void validate() {
        if (this.availablePatchSummary() != null) {
            this.availablePatchSummary().validate();
        }
        if (this.lastPatchInstallationSummary() != null) {
            this.lastPatchInstallationSummary().validate();
        }
        if (this.configurationStatuses() != null) {
            this.configurationStatuses().forEach(e -> e.validate());
        }
    }
}

