/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.SourceVault;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class KeyForDiskEncryptionSet {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(KeyForDiskEncryptionSet.class);
    @JsonProperty(value="sourceVault")
    private SourceVault sourceVault;
    @JsonProperty(value="keyUrl", required=true)
    private String keyUrl;

    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    public KeyForDiskEncryptionSet withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public String keyUrl() {
        return this.keyUrl;
    }

    public KeyForDiskEncryptionSet withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    public void validate() {
        if (this.sourceVault() != null) {
            this.sourceVault().validate();
        }
        if (this.keyUrl() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property keyUrl in model KeyForDiskEncryptionSet"));
        }
    }
}

