/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.recommender.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.recommender.fluent.SpotPlacementScoresClient;
import com.azure.resourcemanager.compute.recommender.fluent.models.ComputeDiagnosticBaseInner;
import com.azure.resourcemanager.compute.recommender.fluent.models.SpotPlacementScoresResponseInner;
import com.azure.resourcemanager.compute.recommender.implementation.ComputeRecommenderManagementClientImpl;
import com.azure.resourcemanager.compute.recommender.models.SpotPlacementScoresInput;
import reactor.core.publisher.Mono;

public final class SpotPlacementScoresClientImpl
implements SpotPlacementScoresClient {
    private final SpotPlacementScoresService service;
    private final ComputeRecommenderManagementClientImpl client;

    SpotPlacementScoresClientImpl(ComputeRecommenderManagementClientImpl client) {
        this.service = (SpotPlacementScoresService)RestProxy.create(SpotPlacementScoresService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ComputeDiagnosticBaseInner>> getWithResponseAsync(String location) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ComputeDiagnosticBaseInner> getAsync(String location) {
        return this.getWithResponseAsync(location).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ComputeDiagnosticBaseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ComputeDiagnosticBaseInner> getWithResponse(String location, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComputeDiagnosticBaseInner get(String location) {
        return (ComputeDiagnosticBaseInner)((Object)this.getWithResponse(location, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SpotPlacementScoresResponseInner>> postWithResponseAsync(String location, SpotPlacementScoresInput spotPlacementScoresInput) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.post(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", "application/json", spotPlacementScoresInput, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SpotPlacementScoresResponseInner> postAsync(String location, SpotPlacementScoresInput spotPlacementScoresInput) {
        return this.postWithResponseAsync(location, spotPlacementScoresInput).flatMap(res -> Mono.justOrEmpty((Object)((SpotPlacementScoresResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SpotPlacementScoresResponseInner> postWithResponse(String location, SpotPlacementScoresInput spotPlacementScoresInput, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.postSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, "application/json", "application/json", spotPlacementScoresInput, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SpotPlacementScoresResponseInner post(String location, SpotPlacementScoresInput spotPlacementScoresInput) {
        return (SpotPlacementScoresResponseInner)this.postWithResponse(location, spotPlacementScoresInput, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ComputeRecommenderManagementClientSpotPlacementScores")
    public static interface SpotPlacementScoresService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/placementScores/spot")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ComputeDiagnosticBaseInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/placementScores/spot")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ComputeDiagnosticBaseInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/placementScores/spot/generate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SpotPlacementScoresResponseInner>> post(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") SpotPlacementScoresInput var7, Context var8);

        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/placementScores/spot/generate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SpotPlacementScoresResponseInner> postSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") SpotPlacementScoresInput var7, Context var8);
    }
}

