/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.TargetReferenceType;
import java.io.IOException;

public final class TargetReference
implements JsonSerializable<TargetReference> {
    private TargetReferenceType type;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(TargetReference.class);

    public TargetReferenceType type() {
        return this.type;
    }

    public TargetReference withType(TargetReferenceType type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public TargetReference withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model TargetReference"));
        }
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model TargetReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static TargetReference fromJson(JsonReader jsonReader) throws IOException {
        return (TargetReference)jsonReader.readObject(reader -> {
            TargetReference deserializedTargetReference = new TargetReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTargetReference.type = TargetReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedTargetReference.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetReference;
        });
    }
}

