/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.BranchStatus;
import java.io.IOException;
import java.util.List;

public final class StepStatus
implements JsonSerializable<StepStatus> {
    private String stepName;
    private String stepId;
    private String status;
    private List<BranchStatus> branches;

    private StepStatus() {
    }

    public String stepName() {
        return this.stepName;
    }

    public String stepId() {
        return this.stepId;
    }

    public String status() {
        return this.status;
    }

    public List<BranchStatus> branches() {
        return this.branches;
    }

    public void validate() {
        if (this.branches() != null) {
            this.branches().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StepStatus fromJson(JsonReader jsonReader) throws IOException {
        return (StepStatus)jsonReader.readObject(reader -> {
            StepStatus deserializedStepStatus = new StepStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stepName".equals(fieldName)) {
                    deserializedStepStatus.stepName = reader.getString();
                    continue;
                }
                if ("stepId".equals(fieldName)) {
                    deserializedStepStatus.stepId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedStepStatus.status = reader.getString();
                    continue;
                }
                if ("branches".equals(fieldName)) {
                    List branches;
                    deserializedStepStatus.branches = branches = reader.readArray(reader1 -> BranchStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStepStatus;
        });
    }
}

