/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyValuePair
implements JsonSerializable<KeyValuePair> {
    private String key;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(KeyValuePair.class);

    public String key() {
        return this.key;
    }

    public KeyValuePair withKey(String key) {
        this.key = key;
        return this;
    }

    public String value() {
        return this.value;
    }

    public KeyValuePair withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.key() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property key in model KeyValuePair"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model KeyValuePair"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static KeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValuePair)jsonReader.readObject(reader -> {
            KeyValuePair deserializedKeyValuePair = new KeyValuePair();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyValuePair.key = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyValuePair.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValuePair;
        });
    }
}

