/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.chaos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.chaos.models.ResourceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ExperimentUpdate
implements JsonSerializable<ExperimentUpdate> {
    private Map<String, String> tags;
    private ResourceIdentity identity;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ExperimentUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ExperimentUpdate withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ExperimentUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentUpdate)jsonReader.readObject(reader -> {
            ExperimentUpdate deserializedExperimentUpdate = new ExperimentUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedExperimentUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedExperimentUpdate.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentUpdate;
        });
    }
}

